/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.shared.StorableKey;
import java.io.File;
import java.io.IOException;

public abstract class StoreException
extends IOException {
    private static final long serialVersionUID = -2550892688074309172L;
    protected final StorableKey _key;

    public StoreException(StorableKey key, String msg) {
        super(msg);
        this._key = key;
    }

    public StoreException(StorableKey key, Throwable t) {
        super(t);
        this._key = key;
    }

    public StoreException(StorableKey key, String msg, Throwable t) {
        super(msg, t);
        this._key = key;
    }

    public StorableKey getKey() {
        return this._key;
    }

    public abstract boolean isInputError();

    public abstract boolean isServerError();

    public static class DB
    extends StoreException {
        private static final long serialVersionUID = 1L;
        protected final DBProblem _type;

        public DB(StorableKey key, DBProblem type, Exception t) {
            super(key, (Throwable)t);
            this._type = type;
        }

        public DB(StorableKey key, DBProblem type, String msg, Exception t) {
            super(key, msg, t);
            this._type = type;
        }

        public DBProblem getType() {
            return this._type;
        }

        @Override
        public boolean isInputError() {
            return false;
        }

        @Override
        public boolean isServerError() {
            return true;
        }
    }

    public static enum DBProblem {
        SECONDARY_INDEX_CORRUPTION,
        OTHER;

    }

    public static class NoSuchFile
    extends IO {
        private static final long serialVersionUID = 1L;

        public NoSuchFile(StorableKey key, File f, String msg) {
            super(key, msg, null);
        }
    }

    public static class IO
    extends StoreException {
        private static final long serialVersionUID = 1L;

        public IO(StorableKey key, IOException t) {
            super(key, (Throwable)t);
        }

        public IO(StorableKey key, String msg, IOException t) {
            super(key, msg, t);
        }

        @Override
        public boolean isInputError() {
            return false;
        }

        @Override
        public boolean isServerError() {
            return true;
        }
    }

    public static class ServerTimeout
    extends StoreException {
        private static final long serialVersionUID = 1L;

        public ServerTimeout(StorableKey key, String msg) {
            super(key, msg);
        }

        public ServerTimeout(StorableKey key, Throwable t) {
            super(key, t);
        }

        public ServerTimeout(Throwable t) {
            super((StorableKey)null, t);
        }

        public ServerTimeout(StorableKey key, String msg, Throwable t) {
            super(key, msg, t);
        }

        @Override
        public boolean isInputError() {
            return false;
        }

        @Override
        public boolean isServerError() {
            return true;
        }
    }

    public static class Internal
    extends StoreException {
        private static final long serialVersionUID = 1L;

        public Internal(StorableKey key, String msg) {
            super(key, msg);
        }

        public Internal(StorableKey key, Throwable t) {
            super(key, t);
        }

        public Internal(StorableKey key, String msg, Throwable t) {
            super(key, msg, t);
        }

        @Override
        public boolean isInputError() {
            return false;
        }

        @Override
        public boolean isServerError() {
            return true;
        }
    }

    public static class Input
    extends StoreException {
        private static final long serialVersionUID = 1L;
        protected final InputProblem _problem;

        public Input(StorableKey key, InputProblem prob, String msg) {
            super(key, msg);
            this._problem = prob;
        }

        @Override
        public boolean isInputError() {
            return true;
        }

        @Override
        public boolean isServerError() {
            return false;
        }

        public InputProblem getProblem() {
            return this._problem;
        }
    }

    public static enum InputProblem {
        BAD_COMPRESSION,
        BAD_CHECKSUM,
        BAD_LENGTH;

    }
}

