/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.store.FileOperationCallback;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StorableCreationResult;
import com.fasterxml.storemate.store.StoreException;
import com.fasterxml.storemate.store.StoreOperationCallback;
import com.fasterxml.storemate.store.StoreOperationSource;
import com.fasterxml.storemate.store.backend.IterationResult;
import java.io.File;
import java.io.IOException;

public abstract class StoreOperationThrottler {
    public abstract Boolean performHas(StoreOperationSource var1, long var2, StorableKey var4, StoreOperationCallback<Boolean> var5) throws IOException, StoreException;

    public abstract Storable performGet(StoreOperationSource var1, long var2, StorableKey var4, StoreOperationCallback<Storable> var5) throws IOException, StoreException;

    public abstract IterationResult performList(StoreOperationSource var1, long var2, StoreOperationCallback<IterationResult> var4) throws IOException, StoreException;

    public abstract StorableCreationResult performPut(StoreOperationSource var1, long var2, StorableKey var4, Storable var5, StoreOperationCallback<StorableCreationResult> var6) throws IOException, StoreException;

    public abstract Storable performSoftDelete(StoreOperationSource var1, long var2, StorableKey var4, StoreOperationCallback<Storable> var5) throws IOException, StoreException;

    public abstract Storable performHardDelete(StoreOperationSource var1, long var2, StorableKey var4, StoreOperationCallback<Storable> var5) throws IOException, StoreException;

    public abstract <OUT> OUT performFileRead(StoreOperationSource var1, long var2, Storable var4, File var5, FileOperationCallback<OUT> var6) throws IOException, StoreException;

    public abstract <OUT> OUT performFileWrite(StoreOperationSource var1, long var2, StorableKey var4, File var5, FileOperationCallback<OUT> var6) throws IOException, StoreException;

    public static class Base
    extends StoreOperationThrottler {
        @Override
        public Boolean performHas(StoreOperationSource source, long operationTime, StorableKey key, StoreOperationCallback<Boolean> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, null);
        }

        @Override
        public Storable performGet(StoreOperationSource source, long operationTime, StorableKey key, StoreOperationCallback<Storable> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, null);
        }

        @Override
        public IterationResult performList(StoreOperationSource source, long operationTime, StoreOperationCallback<IterationResult> cb) throws IOException, StoreException {
            return cb.perform(operationTime, null, null);
        }

        @Override
        public StorableCreationResult performPut(StoreOperationSource source, long operationTime, StorableKey key, Storable value, StoreOperationCallback<StorableCreationResult> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, value);
        }

        @Override
        public Storable performSoftDelete(StoreOperationSource source, long operationTime, StorableKey key, StoreOperationCallback<Storable> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, null);
        }

        @Override
        public Storable performHardDelete(StoreOperationSource source, long operationTime, StorableKey key, StoreOperationCallback<Storable> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, null);
        }

        public <T> T performFileRead(StoreOperationSource source, long operationTime, Storable value, File externalFile, FileOperationCallback<T> cb) throws IOException, StoreException {
            return cb.perform(operationTime, value == null ? null : value.getKey(), value, externalFile);
        }

        public <T> T performFileWrite(StoreOperationSource source, long operationTime, StorableKey key, File externalFile, FileOperationCallback<T> cb) throws IOException, StoreException {
            return cb.perform(operationTime, key, null, externalFile);
        }
    }
}

