/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.backend;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StoreException;
import com.fasterxml.storemate.store.backend.BackendStats;
import com.fasterxml.storemate.store.backend.BackendStatsConfig;
import com.fasterxml.storemate.store.backend.IterationResult;
import com.fasterxml.storemate.store.backend.StorableIterationCallback;
import com.fasterxml.storemate.store.backend.StorableLastModIterationCallback;
import com.fasterxml.storemate.store.impl.StorableConverter;
import com.fasterxml.storemate.store.util.OverwriteChecker;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreBackend {
    protected final Logger LOG;
    protected final StorableConverter _storableConverter;

    protected StoreBackend(StorableConverter storableConverter) {
        this._storableConverter = storableConverter;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }

    protected StoreBackend(StorableConverter storableConverter, Logger log) {
        this._storableConverter = storableConverter;
        this.LOG = log;
    }

    public abstract void start() throws Exception;

    public abstract void prepareForStop() throws Exception;

    public abstract void stop() throws Exception;

    public abstract boolean hasEfficientEntryCount();

    public abstract boolean hasEfficientIndexCount();

    public abstract BackendStats getEntryStatistics(BackendStatsConfig var1);

    public abstract BackendStats getIndexStatistics(BackendStatsConfig var1);

    public abstract File getStorageDirectory();

    public final StorableConverter getStorableConverter() {
        return this._storableConverter;
    }

    public abstract long getEntryCount();

    public abstract long getIndexedCount();

    public abstract long countEntries() throws StoreException;

    public abstract long countIndexed() throws StoreException;

    public abstract boolean hasEntry(StorableKey var1) throws StoreException;

    public abstract Storable findEntry(StorableKey var1) throws StoreException;

    public abstract IterationResult scanEntries(StorableIterationCallback var1) throws StoreException;

    public IterationResult iterateEntriesByKey(StorableIterationCallback cb) throws StoreException {
        return this.iterateEntriesByKey(cb, null);
    }

    public abstract IterationResult iterateEntriesByKey(StorableIterationCallback var1, StorableKey var2) throws StoreException;

    public abstract IterationResult iterateEntriesAfterKey(StorableIterationCallback var1, StorableKey var2) throws StoreException;

    public IterationResult iterateEntriesByModifiedTime(StorableLastModIterationCallback cb) throws StoreException {
        return this.iterateEntriesByModifiedTime(cb, 0L);
    }

    public abstract IterationResult iterateEntriesByModifiedTime(StorableLastModIterationCallback var1, long var2) throws StoreException;

    public abstract Storable createEntry(StorableKey var1, Storable var2) throws IOException, StoreException;

    public abstract Storable putEntry(StorableKey var1, Storable var2) throws IOException, StoreException;

    public abstract void ovewriteEntry(StorableKey var1, Storable var2) throws IOException, StoreException;

    public abstract boolean upsertEntry(StorableKey var1, Storable var2, OverwriteChecker var3, AtomicReference<Storable> var4) throws IOException, StoreException;

    public abstract boolean deleteEntry(StorableKey var1) throws IOException, StoreException;
}

