/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.backend;

import com.fasterxml.storemate.shared.util.RawEntryConverter;
import com.fasterxml.storemate.store.StoreConfig;
import com.fasterxml.storemate.store.backend.StoreBackend;
import com.fasterxml.storemate.store.backend.StoreBackendConfig;
import com.fasterxml.storemate.store.state.NodeStateStore;
import java.io.File;

public abstract class StoreBackendBuilder<T extends StoreBackendConfig> {
    protected final Class<T> _configType;

    protected StoreBackendBuilder(Class<T> configType) {
        this._configType = configType;
    }

    public Class<T> getConfigClass() {
        return this._configType;
    }

    public abstract StoreBackendBuilder<?> with(StoreConfig var1);

    public abstract StoreBackendBuilder<?> with(StoreBackendConfig var1);

    public abstract StoreBackend build();

    public abstract <K, V> NodeStateStore<K, V> buildNodeStateStore(File var1, RawEntryConverter<K> var2, RawEntryConverter<V> var3);

    public abstract <K, V> NodeStateStore<K, V> buildSecondaryNodeStateStore(File var1, String var2, RawEntryConverter<K> var3, RawEntryConverter<V> var4);

    protected File _concatAndCreate(File root, String path) {
        File dir = root;
        for (String part : path.split("/")) {
            if ((part = part.trim()).isEmpty()) continue;
            dir = new File(dir, part);
        }
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IllegalArgumentException("Directory '" + dir.getAbsolutePath() + "' did not exist: failed to create it");
        }
        return dir;
    }
}

