/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.file;

import com.fasterxml.storemate.store.file.FileCleanupStats;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;

public class DirByTime {
    protected final File _dir;
    protected final DateTime _createTime;

    public DirByTime(File dir, DateTime createTime) {
        this._dir = dir;
        this._createTime = createTime;
    }

    public File getDirectory() {
        return this._dir;
    }

    public long getRawCreateTime() {
        return this._createTime.getMillis();
    }

    public int nuke(FileCleanupStats stats, AtomicBoolean shutdown) {
        return this._nukeDir(this._dir, stats, shutdown);
    }

    public boolean removeEmpty(FileCleanupStats stats, AtomicBoolean shutdown) {
        return this._removeEmpty(this._dir, stats, shutdown);
    }

    protected int _nukeDir(File dir, FileCleanupStats stats, AtomicBoolean shutdown) {
        int failed = 0;
        int childCount = 0;
        for (File f : dir.listFiles()) {
            if (shutdown != null && shutdown.get()) {
                return failed;
            }
            ++childCount;
            if (f.isDirectory()) {
                failed += this._nukeDir(f, stats, shutdown);
                continue;
            }
            if (f.delete()) {
                stats.addDeletedFile();
                continue;
            }
            ++failed;
        }
        if (failed == 0) {
            if (dir.delete()) {
                if (childCount == 0) {
                    stats.addDeletedEmptyDir();
                } else {
                    stats.addDeletedDir();
                }
            } else {
                ++failed;
            }
        }
        return failed;
    }

    protected boolean _removeEmpty(File dir, FileCleanupStats stats, AtomicBoolean shutdown) {
        int remaining = 0;
        for (File f : dir.listFiles()) {
            if (shutdown != null && shutdown.get()) break;
            if (f.isDirectory()) {
                if (this._removeEmpty(f, stats, shutdown)) {
                    stats.addDeletedEmptyDir();
                    continue;
                }
                stats.addRemainingDir();
            }
            ++remaining;
        }
        if (remaining > 0) {
            return false;
        }
        return dir.delete();
    }

    public String toString() {
        return this._dir.getAbsolutePath();
    }
}

