/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.file;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.TimeMaster;
import com.fasterxml.storemate.shared.compress.Compression;
import com.fasterxml.storemate.store.file.DirByDate;
import com.fasterxml.storemate.store.file.FileCleanupStats;
import com.fasterxml.storemate.store.file.FileManagerConfig;
import com.fasterxml.storemate.store.file.FileReference;
import com.fasterxml.storemate.store.file.FilenameConverter;
import java.io.File;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final int FILENAME_OVERHEAD = 32;
    private static final int MINUTE_MODULO = 5;
    protected final TimeMaster _timeMaster;
    protected final FilenameConverter _filenameConverter;
    protected final File _dataRoot;
    protected final String _dataRootPath;
    protected final int _maxFilesPerDir;
    protected final int _maxFilenameBaseLength;
    protected File _dateBranch;
    protected long _nextDateCheck;
    protected File _activeBranch;
    protected int _activeBranchId;
    protected String _relativeActivePath;
    protected int _fileIndex;

    public FileManager(FileManagerConfig config, TimeMaster timeMaster, FilenameConverter filenameConverter) {
        this._timeMaster = timeMaster;
        this._filenameConverter = filenameConverter;
        long now = timeMaster.currentTimeMillis();
        File dataRoot = config.dataRoot;
        if (dataRoot == null) {
            throw new IllegalArgumentException("Missing 'dataRoot' configuration value for FileManager");
        }
        if (!dataRoot.exists() && !dataRoot.mkdirs()) {
            throw new IllegalStateException("Data directory '" + dataRoot.getAbsolutePath() + "' did not exist, failed to create");
        }
        this._dataRoot = dataRoot;
        String abs = dataRoot.getAbsolutePath();
        if (!abs.endsWith("/")) {
            abs = abs + "/";
        }
        this._dataRootPath = abs;
        this._calculateDateBranch(now);
        this._maxFilesPerDir = config.maxFilesPerDirectory;
        if (config.maxFilenameLength <= 32) {
            throw new IllegalStateException("Too low setting for 'maxFilenameLength' (" + config.maxFilenameLength + "): must be at least " + 33);
        }
        this._maxFilenameBaseLength = config.maxFilenameLength - 32;
    }

    public File dataRootForTesting() {
        return this._dataRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileReference createStorageFile(StorableKey extKey, Compression compressed, long creationTime) {
        int index;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (creationTime > this._nextDateCheck) {
                this._calculateDateBranch(creationTime);
            }
            if (this._fileIndex >= this._maxFilesPerDir) {
                this._fileIndex = 0;
                ++this._activeBranchId;
                this._activeBranch = new File(this._dateBranch, String.format("%03d", this._activeBranchId));
                if (this._activeBranch.exists()) {
                    this.LOG.warn("Directory {} already exists: will still use as a Data dir...", (Object)this._activeBranch.getAbsolutePath());
                } else {
                    this._activeBranch.mkdirs();
                }
                this._calculateActivePath();
            }
            index = this._fileIndex++;
        }
        String cleanName = this.buildFilename(extKey, index, compressed);
        return new FileReference(new File(this._activeBranch, cleanName), this._relativeActivePath + cleanName);
    }

    public File derefenceFile(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        return new File(this._dataRootPath + relativePath);
    }

    public List<DirByDate> listMainDataDirs(FileCleanupStats stats) {
        return DirByDate.listMainDataDirs(this._dataRoot, stats);
    }

    protected final String buildFilename(StorableKey key, int index, Compression comp) {
        if (comp == null) {
            comp = Compression.NONE;
        }
        int keyLen = key.length();
        StringBuilder sb = new StringBuilder(32 + Math.min(this._maxFilenameBaseLength, keyLen));
        sb = this._appendIndex(sb, index);
        sb.append(':');
        sb = this._filenameConverter.appendFilename(key, sb);
        if (sb.length() > this._maxFilenameBaseLength) {
            sb.setLength(this._maxFilenameBaseLength);
        }
        sb.append('.').append(comp.asChar());
        return sb.toString();
    }

    protected StringBuilder _appendIndex(StringBuilder sb, int index) {
        if (index <= 999) {
            sb.append('0');
            if (index <= 99) {
                sb.append('0');
                if (index <= 9) {
                    sb.append('0');
                }
            }
        }
        sb.append(index);
        return sb;
    }

    protected void _calculateDateBranch(long timestamp) {
        int id;
        File f;
        block2: {
            DateTime dt = new DateTime(timestamp, DateTimeZone.UTC);
            int min = dt.getMinuteOfHour();
            int mod = min % 5;
            if (mod != 0) {
                dt = dt.withMinuteOfHour(min - mod);
            }
            f = new File(this._dataRoot, String.format("%04d-%02d-%02d", dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth()));
            this._dateBranch = new File(f, String.format("%02d:%02d", dt.getHourOfDay(), dt.getMinuteOfHour()));
            this._nextDateCheck = dt.plusMinutes(5).getMillis();
            id = 0;
            do {
                if (!(f = new File(this._dateBranch, String.format("%03d", id))).exists()) break block2;
            } while (++id <= 49999);
            throw new IllegalStateException("Failed to find name for active tip directory under '" + this._dateBranch.getAbsolutePath() + ": tried until " + id);
        }
        f.mkdirs();
        this._activeBranch = f;
        this._activeBranchId = id;
        this._fileIndex = 0;
        this._calculateActivePath();
    }

    protected void _calculateActivePath() {
        StringBuilder sb = new StringBuilder();
        File p = this._activeBranch.getParentFile();
        this._relativeActivePath = sb.append(p.getParentFile().getName()).append('/').append(p.getName()).append('/').append(this._activeBranch.getName()).append('/').toString();
    }
}

