/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.impl;

import com.fasterxml.storemate.shared.ByteContainer;
import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.compress.Compression;
import com.fasterxml.storemate.shared.util.IOUtil;
import com.fasterxml.storemate.shared.util.WithBytesAsArray;
import com.fasterxml.storemate.shared.util.WithBytesCallback;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StorableCreationMetadata;
import com.fasterxml.storemate.store.file.FileReference;
import com.fasterxml.storemate.store.util.BytesToStuff;
import com.fasterxml.storemate.store.util.StuffToBytes;
import java.util.Arrays;

public class StorableConverter {
    public static final int OFFSET_LASTMOD = 0;
    public static final int OFFSET_VERSION = 8;
    public static final int OFFSET_STATUS = 9;
    public static final int OFFSET_COMPRESSION = 10;
    public static final int OFFSET_EXT_PATH_LENGTH = 11;
    public static final int OFFSET_CONTENT_HASH = 12;
    public static final byte VERSION_1 = 17;

    public Storable decode(StorableKey key, byte[] raw) {
        return this.decode(key, raw, 0, raw.length);
    }

    public Storable decode(StorableKey key, byte[] raw, int offset, int length) {
        long originalLength;
        int compressedHash;
        BytesToStuff reader = new BytesToStuff(raw, offset, length);
        long lastmod = reader.nextLong();
        this._verifyVersion(reader.nextByte());
        byte statusFlags = reader.nextByte();
        Compression compression = this._decodeCompression(reader.nextByte());
        int externalPathLength = reader.nextByte() & 0xFF;
        int contentHash = reader.nextInt();
        if (compression != Compression.NONE) {
            compressedHash = reader.nextInt();
            long l = reader.nextVLong();
            if (l == 0L) {
                l = -1L;
            }
            originalLength = l;
        } else {
            compressedHash = 0;
            originalLength = -1L;
        }
        int metadataLength = reader.nextVInt();
        int metadataOffset = reader.offset();
        reader.skip(metadataLength);
        long storageLength = reader.nextVLong();
        int payloadOffset = reader.offset();
        if (externalPathLength > 0) {
            reader.skip(externalPathLength);
        } else {
            reader.skip((int)storageLength);
        }
        int left = reader.left();
        if (left > 0) {
            throw new IllegalArgumentException("Had " + left + " bytes left after decoding entry (out of " + raw.length + ")");
        }
        return new Storable(key, ByteContainer.simple((byte[])raw, (int)offset, (int)length), lastmod, statusFlags, compression, externalPathLength, contentHash, compressedHash, originalLength, metadataOffset, metadataLength, payloadOffset, storageLength);
    }

    public Storable encodeInlined(StorableKey key, long modtime, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, ByteContainer inlineData) {
        StuffToBytes estimator = StuffToBytes.estimator();
        this._encodeInlined(key, estimator, false, modtime, stdMetadata, customMetadata, inlineData);
        StuffToBytes writer = StuffToBytes.writer(estimator.offset());
        return this._encodeInlined(key, writer, true, modtime, stdMetadata, customMetadata, inlineData);
    }

    private Storable _encodeInlined(StorableKey key, StuffToBytes writer, boolean createStorable, long modtime, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, ByteContainer inlineData) {
        int payloadOffset;
        int metadataLength;
        writer.appendLong(modtime).appendByte((byte)17).appendByte(stdMetadata.statusAsByte()).appendByte(stdMetadata.compressionAsByte()).appendByte((byte)0).appendInt(stdMetadata.contentHash);
        if (stdMetadata.usesCompression()) {
            long uncompLen = stdMetadata.uncompressedSize;
            if (uncompLen == -1L) {
                uncompLen = 0L;
            }
            writer.appendInt(stdMetadata.compressedContentHash).appendVLong(uncompLen);
        }
        int metadataOffset = writer.offset();
        if (customMetadata == null) {
            writer.appendVLong(0L);
            metadataLength = 0;
        } else {
            writer.appendLengthAndBytes(customMetadata);
            metadataLength = customMetadata.byteLength();
        }
        if (inlineData == null) {
            writer.appendVInt(0);
            payloadOffset = writer.offset();
        } else {
            writer.appendVInt(inlineData.byteLength());
            payloadOffset = writer.offset();
            writer.appendBytes(inlineData);
        }
        if (!createStorable) {
            return null;
        }
        return new Storable(key, writer.bufferedBytes(), modtime, stdMetadata.statusAsByte(), stdMetadata.compression, 0, stdMetadata.contentHash, stdMetadata.compressedContentHash, stdMetadata.uncompressedSize, metadataOffset, metadataLength, payloadOffset, stdMetadata.storageSize);
    }

    public Storable encodeOfflined(StorableKey key, long modtime, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, FileReference externalData) {
        StuffToBytes estimator = StuffToBytes.estimator();
        this._encodeOfflined(key, estimator, false, modtime, stdMetadata, customMetadata, externalData);
        StuffToBytes writer = StuffToBytes.writer(estimator.offset());
        return this._encodeOfflined(key, writer, true, modtime, stdMetadata, customMetadata, externalData);
    }

    private Storable _encodeOfflined(StorableKey key, StuffToBytes writer, boolean createStorable, long modtime, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, FileReference externalData) {
        int metadataLength;
        byte[] rawRef = IOUtil.getAsciiBytes((String)externalData.getReference());
        if (rawRef.length > 255) {
            throw new IllegalStateException("Length of external reference (" + rawRef.length + ") exceeds 255");
        }
        writer.appendLong(modtime).appendByte((byte)17).appendByte(stdMetadata.statusAsByte()).appendByte(stdMetadata.compressionAsByte()).appendByte((byte)rawRef.length).appendInt(stdMetadata.contentHash);
        if (stdMetadata.usesCompression()) {
            writer.appendInt(stdMetadata.compressedContentHash).appendVLong(stdMetadata.uncompressedSize);
        }
        int metadataOffset = writer.offset();
        if (customMetadata == null) {
            writer.appendVLong(0L);
            metadataLength = 0;
        } else {
            writer.appendLengthAndBytes(customMetadata);
            metadataLength = customMetadata.byteLength();
        }
        writer.appendVLong(stdMetadata.storageSize);
        int payloadOffset = writer.offset();
        writer.appendBytes(rawRef);
        if (!createStorable) {
            return null;
        }
        return new Storable(key, writer.bufferedBytes(), modtime, stdMetadata.statusAsByte(), stdMetadata.compression, rawRef.length, stdMetadata.contentHash, stdMetadata.compressedContentHash, stdMetadata.uncompressedSize, metadataOffset, metadataLength, payloadOffset, stdMetadata.storageSize);
    }

    public Storable softDeletedCopy(StorableKey key, Storable orig, long deletionTime, boolean deleteInlined, boolean deleteExternal) {
        boolean removeInlined;
        boolean removeExternal = deleteExternal && orig.hasExternalData();
        boolean bl = removeInlined = deleteInlined && orig.hasInlineData();
        if (!removeInlined && !removeExternal) {
            byte[] raw = (byte[])orig.withRaw(WithBytesAsArray.instance);
            raw[9] = (byte)(raw[9] | 1);
            this._ovewriteTimestamp(raw, 0, deletionTime);
            return orig.softDeletedCopy(ByteContainer.simple((byte[])raw), false, deletionTime);
        }
        byte[] base = orig.withRawWithoutPayload(new WithBytesCallback<byte[]>(){

            public byte[] withBytes(byte[] buffer, int offset, int length) {
                byte[] result = Arrays.copyOfRange(buffer, offset, length + 1);
                result[9] = (byte)(result[9] | 1);
                result[length] = -128;
                return result;
            }
        });
        if (removeExternal) {
            base[11] = 0;
        }
        this._ovewriteTimestamp(base, 0, deletionTime);
        Storable mod = orig.softDeletedCopy(ByteContainer.simple((byte[])base), true, deletionTime);
        return mod;
    }

    protected void _verifyVersion(byte b) throws IllegalArgumentException {
        byte v = b;
        if (v != 17) {
            throw new IllegalArgumentException("Unsupported version number: 0x" + Integer.toHexString(v) + " (currently only supporting 0x" + Integer.toHexString(17));
        }
    }

    protected boolean _decodeStatusDeleted(byte b) throws IllegalArgumentException {
        return (b & 1) != 0;
    }

    protected boolean _decodeStatusReplicated(byte b) throws IllegalArgumentException {
        return (b & 2) != 0;
    }

    protected void _ovewriteTimestamp(byte[] buffer, int offset, long time) {
        this._putIntBE(buffer, offset += 0, (int)(time >> 32));
        this._putIntBE(buffer, offset + 4, (int)time);
    }

    private void _putIntBE(byte[] buffer, int offset, int value) {
        buffer[offset++] = (byte)(value >> 24);
        buffer[offset++] = (byte)(value >> 16);
        buffer[offset++] = (byte)(value >> 8);
        buffer[offset++] = (byte)value;
    }

    protected Compression _decodeCompression(byte b) throws IllegalArgumentException {
        return Compression.forIndex((int)b, (boolean)true);
    }
}

