/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.state;

import com.fasterxml.storemate.shared.StartAndStoppable;
import com.fasterxml.storemate.shared.util.RawEntryConverter;
import java.io.IOException;
import java.util.List;

public abstract class NodeStateStore<K, V>
implements StartAndStoppable {
    private final RawEntryConverter<K> _keyConverter;
    private final RawEntryConverter<V> _valueConverter;

    protected NodeStateStore(RawEntryConverter<K> keyConverter, RawEntryConverter<V> valueConverter) {
        if (keyConverter == null) {
            throw new IllegalArgumentException("Missing 'keyConverter'");
        }
        if (valueConverter == null) {
            throw new IllegalArgumentException("Missing 'valueConverter'");
        }
        this._keyConverter = keyConverter;
        this._valueConverter = valueConverter;
    }

    public void start() {
    }

    public void prepareForStop() {
    }

    public void stop() {
    }

    public final V findEntry(K key) throws IOException {
        return this._findEntry(this.keyToRaw(key));
    }

    public abstract List<V> readAll() throws IOException;

    public final void upsertEntry(K key, V entry) throws IOException {
        this._upsertEntry(this.keyToRaw(key), this.valueToRaw(entry));
    }

    public boolean deleteEntry(K key) throws IOException {
        return this._deleteEntry(this.keyToRaw(key));
    }

    protected abstract V _findEntry(byte[] var1) throws IOException;

    protected abstract void _upsertEntry(byte[] var1, byte[] var2) throws IOException;

    protected abstract boolean _deleteEntry(byte[] var1) throws IOException;

    protected V rawToValue(byte[] raw, int offset, int length) throws IOException {
        return (V)this._valueConverter.fromRaw(raw, offset, length);
    }

    protected byte[] valueToRaw(V value) throws IOException {
        return this._valueConverter.toRaw(value);
    }

    protected K rawToKey(byte[] raw, int offset, int length) throws IOException {
        return (K)this._keyConverter.fromRaw(raw, offset, length);
    }

    protected byte[] keyToRaw(K key) throws IOException {
        return this._keyConverter.toRaw(key);
    }
}

