/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    protected final InputStream _source;
    protected final long _maxReads;
    protected final boolean _delegateClose;
    protected long _currReads;

    public BoundedInputStream(InputStream source, long maxReads, boolean delegateClose) {
        this._source = source;
        this._maxReads = maxReads;
        if (this._maxReads < 0L) {
            throw new IllegalArgumentException();
        }
        this._delegateClose = delegateClose;
        this._currReads = 0L;
    }

    public final long bytesRead() {
        return this._currReads;
    }

    public final long bytesLeft() {
        return this._maxReads - this._currReads;
    }

    public final boolean isCompletelyRead() {
        return this._currReads == this._maxReads;
    }

    @Override
    public int available() throws IOException {
        long left;
        int a = this._source.available();
        if ((long)a <= (left = this.bytesLeft())) {
            return a;
        }
        return (int)left;
    }

    @Override
    public void close() throws IOException {
        if (this._delegateClose) {
            this._source.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.isCompletelyRead()) {
            return -1;
        }
        ++this._currReads;
        return this._source.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long max = this.bytesLeft();
        if ((long)len > max && (len = (int)max) == 0) {
            return -1;
        }
        int actual = this._source.read(b, off, len);
        if (actual > 0) {
            this._currReads += (long)actual;
        }
        return actual;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        long max = this.bytesLeft();
        if (n > max && (n = max) == 0L) {
            return 0L;
        }
        long actual = this._source.skip(n);
        if (actual > 0L) {
            this._currReads += actual;
        }
        return actual;
    }
}

