/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import java.util.Arrays;

public class BytesToStuff {
    private final byte[] _data;
    private final int _end;
    private int _ptr;

    public BytesToStuff(byte[] data) {
        this(data, 0, data.length);
    }

    public BytesToStuff(byte[] data, int offset, int len) {
        this._data = data;
        this._ptr = offset;
        this._end = offset + len;
    }

    public void skip(int count) {
        this._verifyBounds(count);
        this._ptr += count;
    }

    public int left() {
        return this._end - this._ptr;
    }

    public int offset() {
        return this._ptr;
    }

    public byte nextByte() {
        if (this._ptr >= this._end) {
            this._reportBounds(1);
        }
        return this._data[this._ptr++];
    }

    public byte[] nextBytes(int amount) {
        this._verifyBounds(amount);
        int ptr = this._ptr;
        this._ptr += amount;
        return Arrays.copyOfRange(this._data, ptr, ptr + amount);
    }

    public int nextInt() {
        this._verifyBounds(4);
        return this._nextInt();
    }

    public long nextLong() {
        this._verifyBounds(8);
        long l1 = this._nextInt();
        long l2 = this._nextInt();
        return l1 << 32 | l2 << 32 >>> 32;
    }

    public int nextVInt() {
        int bytesDone = 0;
        int ptr = this._ptr;
        int value = 0;
        while (true) {
            int i;
            ++bytesDone;
            if (ptr >= this._end) {
                this._reportBounds(bytesDone);
            }
            value <<= 7;
            if ((i = this._data[ptr++]) < 0) {
                value += (i &= 0x7F);
                break;
            }
            value += i;
        }
        this._ptr = ptr;
        if (bytesDone > 5) {
            throw new IllegalStateException("Corrupt VInt, shouldn't have more than 5 bytes, had: " + bytesDone);
        }
        return value;
    }

    public long nextVLong() {
        int bytesDone = 0;
        int ptr = this._ptr;
        long value = 0L;
        while (true) {
            int i;
            ++bytesDone;
            if (ptr >= this._end) {
                this._reportBounds(bytesDone);
            }
            value <<= 7;
            if ((i = this._data[ptr++]) < 0) {
                value += (long)(i &= 0x7F);
                break;
            }
            value += (long)i;
        }
        this._ptr = ptr;
        if (bytesDone > 9) {
            throw new IllegalStateException("Corrupt VLong, shouldn't have more than 9 bytes, had: " + bytesDone);
        }
        return value;
    }

    private int _nextInt() {
        int ptr = this._ptr;
        int i = this._data[ptr++] << 24;
        i |= (this._data[ptr++] & 0xFF) << 16;
        i |= (this._data[ptr++] & 0xFF) << 8;
        int n = ptr++;
        this._ptr = ptr;
        return i |= this._data[n] & 0xFF;
    }

    protected void _verifyBounds(int bytesNeeded) {
        if (this._ptr + bytesNeeded > this._end) {
            this._reportBounds(bytesNeeded);
        }
    }

    protected void _reportBounds(int bytesNeeded) {
        int left = this._end - this._ptr;
        throw new IllegalStateException("Unexpected end of data: need " + bytesNeeded + "; only have " + left + " (offset " + this._ptr + ")");
    }
}

