/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.hash.IncrementalHasher32;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    protected final InputStream _in;
    protected final IncrementalHasher32 _hasher;
    protected long _readCount = 0L;
    protected long _skipCount = 0L;
    protected byte[] TMP = null;

    public CountingInputStream(InputStream src) {
        this._in = src;
        this._hasher = null;
    }

    public CountingInputStream(InputStream src, IncrementalHasher32 hasher) {
        this._in = src;
        this._hasher = hasher;
    }

    public long readCount() {
        return this._readCount;
    }

    public long skipCount() {
        return this._skipCount;
    }

    public IncrementalHasher32 getHasher() {
        return this._hasher;
    }

    @Override
    public int available() throws IOException {
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    @Override
    public void mark(int readlimit) {
        this._in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int c = this._in.read();
        if (c >= 0) {
            ++this._readCount;
            if (this._hasher != null) {
                if (this.TMP == null) {
                    this.TMP = new byte[1];
                }
                this.TMP[0] = (byte)c;
                this._hasher.update(this.TMP, 0, 1);
            }
        }
        return c;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int count = this._in.read(b, offset, len);
        if (count > 0) {
            this._readCount += (long)count;
            if (this._hasher != null) {
                this._hasher.update(b, offset, count);
            }
        }
        return count;
    }

    @Override
    public void reset() throws IOException {
        this._in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long l = this._in.skip(n);
        if (l > 0L) {
            this._skipCount += l;
        }
        return l;
    }
}

