/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.hash.IncrementalHasher32;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    protected final OutputStream _out;
    protected long _count = 0L;
    protected final IncrementalHasher32 _hasher;
    protected byte[] TMP = null;

    public CountingOutputStream(OutputStream out) {
        this(out, null);
    }

    public CountingOutputStream(OutputStream out, IncrementalHasher32 hasher) {
        this._out = out;
        this._hasher = hasher;
    }

    public long count() {
        return this._count;
    }

    public IncrementalHasher32 getHasher() {
        return this._hasher;
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._count += (long)len;
        this._out.write(b, off, len);
        if (this._hasher != null) {
            this._hasher.update(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.TMP == null) {
            this.TMP = new byte[1];
        }
        this.TMP[0] = (byte)b;
        this.write(this.TMP, 0, 1);
    }

    public int calculateHash() {
        return this._hasher.calculateHash();
    }
}

