/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.TimeMaster;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.util.TotalTime;
import com.fasterxml.storemate.store.util.TotalTimeAndBytes;

public class OperationDiagnostics {
    protected final long _nanoStart;
    protected Storable _entry;
    protected int _itemCount;
    protected TotalTime _dbAccess;
    protected TotalTimeAndBytes _fileAccess;
    protected boolean _hasFileReads;
    protected boolean _hasFileWrites;
    protected long _requestResponseTotal;

    public OperationDiagnostics(long nanoStart) {
        this._nanoStart = nanoStart;
    }

    public OperationDiagnostics(TimeMaster tm) {
        this(tm.nanosForDiagnostics());
    }

    public OperationDiagnostics setEntry(Storable e) {
        this._entry = e;
        return this;
    }

    public OperationDiagnostics setItemCount(int count) {
        this._itemCount = count;
        return this;
    }

    public void addDbAccess(long nanoStart, long nanoDbStart, TimeMaster timeMaster) {
        this.addDbAccess(nanoStart, nanoDbStart, timeMaster.nanosForDiagnostics());
    }

    public void addDbAccess(long nanoStart, long nanoDbStart, long endTime) {
        long rawTime = endTime - nanoDbStart;
        long timeWithWait = endTime - nanoStart;
        this._dbAccess = TotalTime.createOrAdd(this._dbAccess, rawTime, timeWithWait);
    }

    public void addFileReadAccess(long nanoStart, TimeMaster timeMaster, long bytes) {
        this.addFileReadAccess(nanoStart, nanoStart, timeMaster.nanosForDiagnostics(), bytes);
    }

    public void addFileReadAccess(long nanoStart, long nanoFileStart, TimeMaster timeMaster, long bytes) {
        this.addFileReadAccess(nanoStart, nanoFileStart, timeMaster.nanosForDiagnostics(), bytes);
    }

    public void addFileReadAccess(long nanoStart, long nanoFileStart, long endTime, long bytes) {
        this._hasFileReads = true;
        long rawTime = endTime - nanoFileStart;
        long timeWithWait = endTime - nanoStart;
        this._fileAccess = TotalTimeAndBytes.createOrAdd(this._fileAccess, rawTime, timeWithWait, bytes);
    }

    public void addFileReadWait(long waitTime) {
        this._hasFileReads = true;
        this._fileAccess = TotalTimeAndBytes.createOrAdd(this._fileAccess, 0L, waitTime, 0L);
    }

    public void addFileWriteAccess(long nanoStart, TimeMaster timeMaster, long bytes) {
        this.addFileWriteAccess(nanoStart, nanoStart, timeMaster.nanosForDiagnostics(), bytes);
    }

    public void addFileWriteAccess(long nanoStart, long nanoFileStart, TimeMaster timeMaster, long bytes) {
        this.addFileWriteAccess(nanoStart, nanoFileStart, timeMaster.nanosForDiagnostics(), bytes);
    }

    public void addFileWriteAccess(long nanoStart, long nanoFileStart, long endTime, long bytes) {
        this._hasFileWrites = true;
        long rawTime = endTime - nanoFileStart;
        long timeWithWait = endTime - nanoStart;
        this._fileAccess = TotalTimeAndBytes.createOrAdd(this._fileAccess, rawTime, timeWithWait, bytes);
    }

    public void addFileWriteWait(long waitTime) {
        this._hasFileWrites = true;
        this._fileAccess = TotalTimeAndBytes.createOrAdd(this._fileAccess, 0L, waitTime, 0L);
    }

    public void addRequestReadTime(long nanoStart, TimeMaster tm) {
        this.addRequestReadTime(nanoStart, tm.nanosForDiagnostics());
    }

    public void addRequestReadTime(long nanoStart, long nanoEnd) {
        this._requestResponseTotal += nanoEnd - nanoStart;
    }

    public void addResponseWriteTime(long nanoStart, TimeMaster tm) {
        this.addResponseWriteTime(nanoStart, tm.nanosForDiagnostics());
    }

    public void addResponseWriteTime(long nanoStart, long nanoEnd) {
        this.addResponseWriteTime(nanoEnd - nanoStart);
    }

    public void addResponseWriteTime(long nanoSecs) {
        this._requestResponseTotal += nanoSecs;
    }

    public Storable getEntry() {
        return this._entry;
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public long getNanosSpent() {
        return System.nanoTime() - this._nanoStart;
    }

    public boolean hasDbAccess() {
        return this._dbAccess != null;
    }

    public boolean hasFileAccess() {
        return this._fileAccess != null;
    }

    public boolean hasFileReads() {
        return this._hasFileReads;
    }

    public boolean hasFileWrites() {
        return this._hasFileWrites;
    }

    public boolean hasRequestResponseTotal() {
        return this._requestResponseTotal > 0L;
    }

    public long getRequestResponseTotal() {
        return this._requestResponseTotal;
    }

    public TotalTime getDbAccess() {
        return this._dbAccess;
    }

    public TotalTimeAndBytes getFileAccess() {
        return this._fileAccess;
    }
}

