/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StoreException;

public interface OverwriteChecker {
    public Boolean mayOverwrite(StorableKey var1);

    public boolean mayOverwrite(StorableKey var1, Storable var2, Storable var3) throws StoreException;

    public static class NeverOkToOverwrite
    implements OverwriteChecker {
        public static final OverwriteChecker instance = new NeverOkToOverwrite();

        @Override
        public Boolean mayOverwrite(StorableKey key) {
            return Boolean.FALSE;
        }

        @Override
        public boolean mayOverwrite(StorableKey key, Storable oldEntry, Storable newEntry) throws StoreException {
            return false;
        }
    }

    public static class AlwaysOkToOverwrite
    implements OverwriteChecker {
        public static final OverwriteChecker instance = new AlwaysOkToOverwrite();

        @Override
        public Boolean mayOverwrite(StorableKey key) {
            return Boolean.TRUE;
        }

        @Override
        public boolean mayOverwrite(StorableKey key, Storable oldEntry, Storable newEntry) throws StoreException {
            return true;
        }
    }
}

