/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.store.StoreException;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLongArray;

public class PartitionedWriteMutex {
    private static final int MIN_PARTITIONS = 4;
    private static final int MAX_PARTITIONS = 256;
    protected final int _modulo;
    protected final Semaphore[] _semaphores;
    protected final AtomicLongArray _inFlightStartTimes;

    public PartitionedWriteMutex(int n, boolean fair) {
        n = PartitionedWriteMutex.powerOf2(n);
        this._modulo = n - 1;
        this._semaphores = new Semaphore[n];
        for (int i = 0; i < n; ++i) {
            this._semaphores[i] = new Semaphore(1, fair);
        }
        this._inFlightStartTimes = new AtomicLongArray(n);
    }

    private static final int powerOf2(int n) {
        int m;
        if (n <= 4) {
            return 4;
        }
        if (n >= 256) {
            return 256;
        }
        for (m = 4; m < n; m += m) {
        }
        return m;
    }

    public long getOldestInFlightTimestamp() {
        long lowest = Long.MAX_VALUE;
        int last = this._modulo;
        for (int i = 0; i <= last; ++i) {
            long timestamp = this._inFlightStartTimes.get(i);
            if (timestamp <= 0L || timestamp >= lowest) continue;
            lowest = timestamp;
        }
        return lowest == Long.MAX_VALUE ? 0L : lowest;
    }

    public int getInFlightWritesCount() {
        int count = 0;
        int last = this._modulo;
        for (int i = 0; i <= last; ++i) {
            long timestamp = this._inFlightStartTimes.get(i);
            if (timestamp == 0L) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T partitionedWrite(long operationTime, StorableKey key, Callback<T> cb) throws IOException, StoreException {
        int partition = this._partitionFor(key);
        Semaphore semaphore = this._semaphores[partition];
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            semaphore.release();
            throw new StoreException.Internal(key, "partitionedWrite() Semaphore-wait for " + key + " interrupted (" + e.getClass().getName() + "), message: " + e.getMessage(), e);
        }
        this._inFlightStartTimes.set(partition, operationTime);
        try {
            T t = cb.performWrite(key);
            return t;
        }
        finally {
            this._inFlightStartTimes.set(partition, 0L);
            semaphore.release();
        }
    }

    private final int _partitionFor(StorableKey key) {
        int hash = key.hashCode();
        hash ^= hash >>> 15;
        hash += hash >>> 7;
        return hash & this._modulo;
    }

    public static interface Callback<T> {
        public T performWrite(StorableKey var1) throws IOException, StoreException;
    }
}

