/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class SimpleLogThrottler {
    private final Logger _logger;
    private final AtomicLong suppressUntil = new AtomicLong(0L);
    private final AtomicInteger suppressCount = new AtomicInteger(0);
    private final int delayBetweenMsecs;

    public SimpleLogThrottler(Logger logger, int msecsToThrottle) {
        this._logger = logger;
        this.delayBetweenMsecs = msecsToThrottle;
    }

    public boolean logWarn(String msg, Object ... arguments) {
        return this.logWarn(System.currentTimeMillis(), msg, arguments);
    }

    public boolean logWarn(long timeNow, String msg, Object ... arguments) {
        Integer supp = this.canProceed(timeNow);
        if (supp == null) {
            return false;
        }
        if (supp > 0) {
            this._logger.warn("(suppressed {}) " + msg, (Object)supp, (Object)arguments);
        } else {
            this._logger.warn(msg, arguments);
        }
        return true;
    }

    public boolean logError(String msg, Object ... arguments) {
        return this.logError(System.currentTimeMillis(), msg, arguments);
    }

    public boolean logError(long timeNow, String msg, Object ... arguments) {
        Integer supp = this.canProceed(timeNow);
        if (supp == null) {
            return false;
        }
        if (supp > 0) {
            this._logger.error("(suppressed {}) " + msg, (Object)supp, (Object)arguments);
        } else {
            this._logger.error(msg, arguments);
        }
        return true;
    }

    protected Integer canProceed(long timeNow) {
        long until = this.suppressUntil.get();
        if (timeNow < until || !this.suppressUntil.compareAndSet(until, timeNow + (long)this.delayBetweenMsecs)) {
            this.suppressCount.addAndGet(1);
            return null;
        }
        int suppressed = this.suppressCount.getAndSet(0);
        return suppressed;
    }

    protected long willSuppressUntil() {
        return this.suppressUntil.get();
    }

    protected int suppressCount() {
        return this.suppressCount.get();
    }
}

