/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.StorageMode;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.storage_mode_t;
import com.frostwire.jlibtorrent.swig.string_int_pair;
import com.frostwire.jlibtorrent.swig.string_int_pair_vector;
import com.frostwire.jlibtorrent.swig.string_vector;
import java.util.ArrayList;
import java.util.List;

public final class AddTorrentParams {
    private final add_torrent_params p;

    public AddTorrentParams(add_torrent_params p) {
        this.p = p;
    }

    public AddTorrentParams() {
        this(add_torrent_params.create_instance());
    }

    public add_torrent_params swig() {
        return this.p;
    }

    public int version() {
        return this.p.getVersion();
    }

    public ArrayList<String> trackers() {
        string_vector v = this.p.getTrackers();
        int size = (int)v.size();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            l.add(v.get(i));
        }
        return l;
    }

    public void trackers(List<String> value) {
        string_vector v = new string_vector();
        for (String s : value) {
            v.push_back(s);
        }
        this.p.setTrackers(v);
    }

    public ArrayList<String> urlSeeds() {
        string_vector v = this.p.getUrl_seeds();
        int size = (int)v.size();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            l.add(v.get(i));
        }
        return l;
    }

    public void urlSeeds(List<String> value) {
        string_vector v = new string_vector();
        for (String s : value) {
            v.push_back(s);
        }
        this.p.setUrl_seeds(v);
    }

    public ArrayList<Pair<String, Integer>> dhtNodes() {
        string_int_pair_vector v = this.p.getDht_nodes();
        int size = (int)v.size();
        ArrayList<Pair<String, Integer>> l = new ArrayList<Pair<String, Integer>>();
        for (int i = 0; i < size; ++i) {
            string_int_pair n = v.get(i);
            l.add(new Pair<String, Integer>(n.getFirst(), n.getSecond()));
        }
        return l;
    }

    public void dhtNodes(List<Pair<String, Integer>> value) {
        string_int_pair_vector v = new string_int_pair_vector();
        for (Pair<String, Integer> p : value) {
            v.push_back(p.to_string_int_pair());
        }
        this.p.setDht_nodes(v);
    }

    public String name() {
        return this.p.getName();
    }

    public void name(String value) {
        this.p.setName(value);
    }

    public String savePath() {
        return this.p.getSave_path();
    }

    public void savePath(String value) {
        this.p.setSave_path(value);
    }

    public StorageMode storageMode() {
        return StorageMode.fromSwig(this.p.getStorage_mode().swigValue());
    }

    public void storageMode(StorageMode value) {
        this.p.setStorage_mode(storage_mode_t.swigToEnum(value.swig()));
    }

    public String trackerId() {
        return this.p.getTrackerid();
    }

    public void trackerId(String value) {
        this.p.setTrackerid(value);
    }

    public String url() {
        return this.p.getUrl();
    }

    public void url(String value) {
        this.p.setUrl(value);
    }

    public String uuid() {
        return this.p.getUuid();
    }

    public void uuid(String value) {
        this.p.setUuid(value);
    }

    public String sourceFeedUrl() {
        return this.p.getSource_feed_url();
    }

    public void sourceFeedUrl(String value) {
        this.p.setSource_feed_url(value);
    }

    public Sha1Hash infoHash() {
        return new Sha1Hash(this.p.getInfo_hash());
    }

    public void infoHash(Sha1Hash value) {
        this.p.setInfo_hash(value.swig());
    }

    public long flags() {
        return this.p.get_flags();
    }

    public void flags(long flags) {
        this.p.set_flags(flags);
    }

    public void torrentInfo(TorrentInfo ti) {
        this.p.set_ti(ti.swig());
    }

    public void resumeData(byte[] data) {
        this.p.set_resume_data(Vectors.bytes2byte_vector(data));
    }

    public void filePriorities(Priority[] priorities) {
        this.p.set_file_priorities(Priority.array2byte_vector(priorities));
    }

    public static AddTorrentParams createInstance() {
        return new AddTorrentParams(add_torrent_params.create_instance());
    }

    public static AddTorrentParams createInstanceDisabledStorage() {
        return new AddTorrentParams(add_torrent_params.create_instance_disabled_storage());
    }

    public static AddTorrentParams createInstanceZeroStorage() {
        return new AddTorrentParams(add_torrent_params.create_instance_zero_storage());
    }
}

