/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.Session;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.alerts.AlertType;
import java.io.File;

public final class Downloader {
    private static final Logger LOG = Logger.getLogger(Downloader.class);
    private static final int[] LISTENER_TYPES = new int[]{AlertType.METADATA_RECEIVED.swig()};
    private final Session s;

    public Downloader(Session s) {
        this.s = s;
    }

    public TorrentHandle find(Sha1Hash infoHash) {
        return this.s.findTorrent(infoHash);
    }

    public TorrentHandle find(String infoHash) {
        return this.s.findTorrent(new Sha1Hash(infoHash));
    }

    public void download(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile) {
        TorrentHandle th = this.s.findTorrent(ti.infoHash());
        if (th != null) {
            if (priorities != null) {
                if (ti.numFiles() != priorities.length) {
                    throw new IllegalArgumentException("The priorities length should be equals to the number of files");
                }
                th.prioritizeFiles(priorities);
            } else {
                Priority[] wholeTorrentPriorities = Priority.array(Priority.NORMAL, ti.numFiles());
                th.prioritizeFiles(wholeTorrentPriorities);
            }
        } else {
            this.s.asyncAddTorrent(ti, saveDir, priorities, resumeFile);
        }
    }

    public void download(TorrentInfo ti, File saveDir) {
        this.download(ti, saveDir, null, null);
    }

    public byte[] fetchMagnet(String uri, int timeout) {
        return this.s.fetchMagnet(uri, timeout);
    }
}

