/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.entry_list;
import com.frostwire.jlibtorrent.swig.entry_vector;
import com.frostwire.jlibtorrent.swig.string_entry_map;
import com.frostwire.jlibtorrent.swig.string_vector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Entry {
    private final entry e;

    public Entry(entry e) {
        this.e = e;
    }

    public Entry(String s) {
        this(new entry(s));
    }

    public Entry(long n) {
        this(new entry(n));
    }

    public entry swig() {
        return this.e;
    }

    public byte[] bencode() {
        return Vectors.byte_vector2bytes(this.e.bencode());
    }

    public String string() {
        return this.e.string();
    }

    public long integer() {
        return this.e.integer();
    }

    public ArrayList<Entry> list() {
        entry_vector v = this.e.list().to_vector();
        int size = (int)v.size();
        ArrayList<Entry> list = new ArrayList<Entry>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new Entry(v.get(i)));
        }
        return list;
    }

    public Map<String, Entry> dictionary() {
        string_entry_map dict = this.e.dict();
        string_vector keys = dict.keys();
        int size = (int)keys.size();
        HashMap<String, Entry> map = new HashMap<String, Entry>(size);
        for (int i = 0; i < size; ++i) {
            String key = keys.get(i);
            Entry value = new Entry(dict.get(key));
            map.put(key, value);
        }
        return map;
    }

    public String toString() {
        return this.e.to_string();
    }

    public static Entry bdecode(byte[] data) {
        return new Entry(entry.bdecode(Vectors.bytes2byte_vector(data)));
    }

    public static Entry bdecode(File file) throws IOException {
        byte[] data = Files.bytes(file);
        return Entry.bdecode(data);
    }

    public static Entry fromList(List<?> list) {
        entry e = new entry(entry.data_type.list_t);
        entry_list d = e.list();
        for (Object v : list) {
            if (v instanceof String) {
                d.push_back(new entry((String)v));
                continue;
            }
            if (v instanceof Integer) {
                d.push_back(new entry(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof Entry) {
                d.push_back(((Entry)v).swig());
                continue;
            }
            if (v instanceof entry) {
                d.push_back((entry)v);
                continue;
            }
            if (v instanceof List) {
                d.push_back(Entry.fromList((List)v).swig());
                continue;
            }
            if (v instanceof Map) {
                d.push_back(Entry.fromMap((Map)v).swig());
                continue;
            }
            d.push_back(new entry(v.toString()));
        }
        return new Entry(e);
    }

    public static Entry fromMap(Map<?, ?> map) {
        entry e = new entry(entry.data_type.dictionary_t);
        string_entry_map d = e.dict();
        for (Map.Entry<?, ?> kv : map.entrySet()) {
            String k = kv.getKey().toString();
            Object v = kv.getValue();
            if (v instanceof String) {
                d.set(k, new entry((String)v));
                continue;
            }
            if (v instanceof Integer) {
                d.set(k, new entry(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof Entry) {
                d.set(k, ((Entry)v).swig());
                continue;
            }
            if (v instanceof entry) {
                d.set(k, (entry)v);
                continue;
            }
            if (v instanceof List) {
                d.set(k, Entry.fromList((List)v).swig());
                continue;
            }
            if (v instanceof Map) {
                d.set(k, Entry.fromMap((Map)v).swig());
                continue;
            }
            d.set(k, new entry(v.toString()));
        }
        return new Entry(e);
    }
}

