/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.FileSlice;
import com.frostwire.jlibtorrent.PeerRequest;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.swig.file_slice_vector;
import com.frostwire.jlibtorrent.swig.file_storage;
import com.frostwire.jlibtorrent.swig.torrent_info;
import java.io.File;
import java.util.ArrayList;

public final class FileStorage {
    private final torrent_info ti;
    private final file_storage fs;

    public FileStorage(file_storage fs) {
        this.ti = null;
        this.fs = fs;
    }

    FileStorage(torrent_info ti, file_storage fs) {
        this.ti = ti;
        this.fs = fs;
    }

    public file_storage swig() {
        return this.fs;
    }

    public torrent_info getTi() {
        return this.ti;
    }

    public boolean isValid() {
        return this.fs.is_valid();
    }

    public void reserve(int numFiles) {
        this.fs.reserve(numFiles);
    }

    public void addFile(String path, long fileSize, Flags fileFlags, int mtime, String symlinkPath) {
        this.fs.add_file(path, fileSize, fileFlags.swig(), mtime, symlinkPath);
    }

    public void addFile(String p, long size, Flags flags, int mtime) {
        this.fs.add_file(p, size, flags.swig(), mtime);
    }

    public void addFile(String p, long size, Flags flags) {
        this.fs.add_file(p, size, flags.swig());
    }

    public void addFile(String p, long size) {
        this.fs.add_file(p, size);
    }

    public void renameFile(int index, String newFilename) {
        this.fs.rename_file(index, newFilename);
    }

    public ArrayList<FileSlice> mapBlock(int piece, long offset, int size) {
        return FileStorage.mapBlock(this.fs.map_block(piece, offset, size));
    }

    public PeerRequest mapFile(int file, long offset, int size) {
        return new PeerRequest(this.fs.map_file(file, offset, size));
    }

    public int numFiles() {
        return this.fs.num_files();
    }

    public long totalSize() {
        return this.fs.total_size();
    }

    public int numPieces() {
        return this.fs.num_pieces();
    }

    public void numPieces(int n) {
        this.fs.set_num_pieces(n);
    }

    public int pieceLength() {
        return this.fs.piece_length();
    }

    public void pieceLength(int l) {
        this.fs.set_piece_length(l);
    }

    public int pieceSize(int index) {
        return this.fs.piece_size(index);
    }

    public String name() {
        return this.fs.name();
    }

    public void name(String name) {
        this.fs.set_name(name);
    }

    public Sha1Hash hash(int index) {
        return new Sha1Hash(this.fs.hash(index));
    }

    public String filePath(int index, String savePath) {
        return savePath + File.separator + this.fs.file_path(index);
    }

    public String filePath(int index) {
        return this.fs.file_path(index);
    }

    public String fileName(int index) {
        return this.fs.file_name(index);
    }

    public long fileSize(int index) {
        return this.fs.file_size(index);
    }

    public boolean padFileAt(int index) {
        return this.fs.pad_file_at(index);
    }

    public long fileOffset(int index) {
        return this.fs.file_offset(index);
    }

    static ArrayList<FileSlice> mapBlock(file_slice_vector v) {
        int size = (int)v.size();
        ArrayList<FileSlice> l = new ArrayList<FileSlice>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new FileSlice(v.get(i)));
        }
        return l;
    }

    public static enum Flags {
        PAD_FILE(file_storage.flags_t.pad_file.swigValue()),
        ATTRIBUTE_HIDDEN(file_storage.flags_t.attribute_hidden.swigValue()),
        ATTRIBUTE_EXECUTABLE(file_storage.flags_t.attribute_executable.swigValue()),
        ATTRIBUTE_SYMLINK(file_storage.flags_t.attribute_symlink.swigValue()),
        UNKNOWN(-1);

        private final int swigValue;

        private Flags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }

        public static Flags fromSwig(int swigValue) {
            Flags[] enumValues;
            for (Flags ev : enumValues = (Flags[])Flags.class.getEnumConstants()) {
                if (ev.swig() != swigValue) continue;
                return ev;
            }
            return UNKNOWN;
        }
    }
}

