/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Bitfield;
import com.frostwire.jlibtorrent.ErrorCode;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.StorageMode;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.swig.torrent_status;

public final class TorrentStatus {
    private final torrent_status ts;

    public TorrentStatus(torrent_status ts) {
        this.ts = ts;
    }

    public TorrentHandle handle() {
        return new TorrentHandle(this.ts.getHandle());
    }

    public ErrorCode errorCode() {
        return new ErrorCode(this.ts.getErrc());
    }

    public String name() {
        return this.ts.getName();
    }

    public long nextAnnounce() {
        return this.ts.get_next_announce();
    }

    public String currentTracker() {
        return this.ts.getCurrent_tracker();
    }

    public long totalDownload() {
        return this.ts.getTotal_download();
    }

    public long totalUpload() {
        return this.ts.getTotal_upload();
    }

    public long totalPayloadDownload() {
        return this.ts.getTotal_payload_download();
    }

    public long totalPayloadUpload() {
        return this.ts.getTotal_payload_upload();
    }

    public long totalFailedBytes() {
        return this.ts.getTotal_failed_bytes();
    }

    public long totalRedundantBytes() {
        return this.ts.getTotal_redundant_bytes();
    }

    public Bitfield pieces() {
        return new Bitfield(this.ts.getPieces());
    }

    public Bitfield getVerifiedPieces() {
        return new Bitfield(this.ts.getVerified_pieces());
    }

    public long getTotalDone() {
        return this.ts.getTotal_done();
    }

    public long getTotalWantedDone() {
        return this.ts.getTotal_wanted_done();
    }

    public long getTotalWanted() {
        return this.ts.getTotal_wanted();
    }

    public long getAllTimeUpload() {
        return this.ts.getAll_time_upload();
    }

    public long getAllTimeDownload() {
        return this.ts.getAll_time_download();
    }

    public long getAddedTime() {
        return TorrentStatus.time2millis(this.ts.getAdded_time());
    }

    public long getCompletedTime() {
        return TorrentStatus.time2millis(this.ts.getCompleted_time());
    }

    public long lastSeenComplete() {
        return TorrentStatus.time2millis(this.ts.getLast_seen_complete());
    }

    public final StorageMode storageMode() {
        return StorageMode.fromSwig(this.ts.getStorage_mode().swigValue());
    }

    public float getProgress() {
        return this.ts.getProgress();
    }

    public int getProgressPpm() {
        return this.ts.getProgress_ppm();
    }

    public int getQueuePosition() {
        return this.ts.getQueue_position();
    }

    public int getDownloadRate() {
        return this.ts.getDownload_rate();
    }

    public int getUploadRate() {
        return this.ts.getUpload_rate();
    }

    public int getDownloadPayloadRate() {
        return this.ts.getDownload_payload_rate();
    }

    public int getUploadPayloadRate() {
        return this.ts.getUpload_payload_rate();
    }

    public int getNumSeeds() {
        return this.ts.getNum_seeds();
    }

    public int getNumPeers() {
        return this.ts.getNum_peers();
    }

    public int getNumComplete() {
        return this.ts.getNum_complete();
    }

    public int getNumIncomplete() {
        return this.ts.getNum_incomplete();
    }

    public int getListSeeds() {
        return this.ts.getList_seeds();
    }

    public int getListPeers() {
        return this.ts.getList_peers();
    }

    public int getConnectCandidates() {
        return this.ts.getConnect_candidates();
    }

    public int getNumPieces() {
        return this.ts.getNum_pieces();
    }

    public int getDistributedFullCopies() {
        return this.ts.getDistributed_full_copies();
    }

    public int getDistributedFraction() {
        return this.ts.getDistributed_fraction();
    }

    public float getDistributedCopies() {
        return this.ts.getDistributed_copies();
    }

    public int getBlockSize() {
        return this.ts.getBlock_size();
    }

    public int getNumUploads() {
        return this.ts.getNum_uploads();
    }

    public int getNumConnections() {
        return this.ts.getNum_connections();
    }

    public State getState() {
        return State.fromSwig(this.ts.getState().swigValue());
    }

    public boolean needSaveResume() {
        return this.ts.getNeed_save_resume();
    }

    public boolean ipFilterApplies() {
        return this.ts.getIp_filter_applies();
    }

    public boolean isUploadMode() {
        return this.ts.getUpload_mode();
    }

    public boolean isShareMode() {
        return this.ts.getShare_mode();
    }

    public boolean isSuperSeeding() {
        return this.ts.getSuper_seeding();
    }

    public boolean isPaused() {
        return this.ts.getPaused();
    }

    public boolean isAutoManaged() {
        return this.ts.getAuto_managed();
    }

    public boolean isSequentialDownload() {
        return this.ts.getSequential_download();
    }

    public boolean isSeeding() {
        return this.ts.getIs_seeding();
    }

    public boolean isFinished() {
        return this.ts.getIs_finished();
    }

    public boolean hasMetadata() {
        return this.ts.getHas_metadata();
    }

    public boolean hasIncoming() {
        return this.ts.getHas_incoming();
    }

    public boolean isSeedMode() {
        return this.ts.getSeed_mode();
    }

    public boolean isMovingStorage() {
        return this.ts.getMoving_storage();
    }

    public boolean isLoaded() {
        return this.ts.getIs_loaded();
    }

    public boolean announcingToTrackers() {
        return this.ts.getAnnouncing_to_trackers();
    }

    public boolean announcingToLsd() {
        return this.ts.getAnnouncing_to_lsd();
    }

    public boolean announcingToDht() {
        return this.ts.getAnnouncing_to_dht();
    }

    public boolean stopWhenReady() {
        return this.ts.getStop_when_ready();
    }

    public Sha1Hash getInfoHash() {
        return new Sha1Hash(this.ts.getInfo_hash());
    }

    private static long time2millis(int time) {
        return (long)time * 1000L;
    }

    public static enum State {
        UNUSED_ENUM_FOR_BACKWARDS_COMPATIBILITY(torrent_status.state_t.unused_enum_for_backwards_compatibility.swigValue()),
        CHECKING_FILES(torrent_status.state_t.checking_files.swigValue()),
        DOWNLOADING_METADATA(torrent_status.state_t.downloading_metadata.swigValue()),
        DOWNLOADING(torrent_status.state_t.downloading.swigValue()),
        FINISHED(torrent_status.state_t.finished.swigValue()),
        SEEDING(torrent_status.state_t.seeding.swigValue()),
        ALLOCATING(torrent_status.state_t.allocating.swigValue()),
        CHECKING_RESUME_DATA(torrent_status.state_t.checking_resume_data.swigValue()),
        UNKNOWN(-1),
        QUEUED_FOR_CHECKING(torrent_status.state_t.unused_enum_for_backwards_compatibility.swigValue());

        private final int swigValue;

        private State(int swigValue) {
            this.swigValue = swigValue;
        }

        public int getSwig() {
            return this.swigValue;
        }

        public static State fromSwig(int swigValue) {
            State[] enumValues;
            for (State ev : enumValues = (State[])State.class.getEnumConstants()) {
                if (ev.getSwig() != swigValue) continue;
                return ev;
            }
            return UNKNOWN;
        }
    }
}

