/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.JavaStatChannel;
import com.frostwire.jlibtorrent.swig.stat;

final class JavaStat {
    public static final int UPLOAD_PAYLOAD = com.frostwire.jlibtorrent.swig.stat.upload_payload;
    public static final int UPLOAD_PROTOCOL = com.frostwire.jlibtorrent.swig.stat.upload_protocol;
    public static final int DOWNLOAD_PAYLOAD = com.frostwire.jlibtorrent.swig.stat.download_payload;
    public static final int DOWNLOAD_PROTOCOL = com.frostwire.jlibtorrent.swig.stat.download_protocol;
    public static final int UPLOAD_IP_PROTOCOL = com.frostwire.jlibtorrent.swig.stat.upload_ip_protocol;
    public static final int DOWNLOAD_IP_PROTOCOL = com.frostwire.jlibtorrent.swig.stat.download_ip_protocol;
    public static final int NUM_CHANNELS = com.frostwire.jlibtorrent.swig.stat.num_channels;
    private final JavaStatChannel[] stat = new JavaStatChannel[NUM_CHANNELS];

    public JavaStat() {
        for (int i = 0; i < this.stat.length; ++i) {
            this.stat[i] = new JavaStatChannel();
        }
    }

    public void sent(long payload, long protocol, long ip) {
        this.stat[UPLOAD_PAYLOAD].add(payload);
        this.stat[UPLOAD_PROTOCOL].add(protocol);
        this.stat[UPLOAD_IP_PROTOCOL].add(ip);
    }

    public void received(long payload, long protocol, long ip) {
        this.stat[DOWNLOAD_PAYLOAD].add(payload);
        this.stat[DOWNLOAD_PROTOCOL].add(protocol);
        this.stat[DOWNLOAD_IP_PROTOCOL].add(ip);
    }

    public void secondTick(long tickIntervalMs) {
        for (int i = 0; i < NUM_CHANNELS; ++i) {
            this.stat[i].secondTick(tickIntervalMs);
        }
    }

    public long uploadRate() {
        return this.stat[UPLOAD_PAYLOAD].rate() + this.stat[UPLOAD_PROTOCOL].rate() + this.stat[UPLOAD_IP_PROTOCOL].rate();
    }

    public long downloadRate() {
        return this.stat[DOWNLOAD_PAYLOAD].rate() + this.stat[DOWNLOAD_PROTOCOL].rate() + this.stat[DOWNLOAD_IP_PROTOCOL].rate();
    }

    public long upload() {
        return this.stat[UPLOAD_PAYLOAD].total() + this.stat[UPLOAD_PROTOCOL].total() + this.stat[UPLOAD_IP_PROTOCOL].total();
    }

    public long download() {
        return this.stat[DOWNLOAD_PAYLOAD].total() + this.stat[DOWNLOAD_PROTOCOL].total() + this.stat[DOWNLOAD_IP_PROTOCOL].total();
    }

    public long uploadPayloadRate() {
        return this.stat[UPLOAD_PAYLOAD].rate();
    }

    public long downloadPayloadRate() {
        return this.stat[DOWNLOAD_PAYLOAD].rate();
    }

    public long uploadPayload() {
        return this.stat[UPLOAD_PAYLOAD].total();
    }

    public long downloadPayload() {
        return this.stat[DOWNLOAD_PAYLOAD].total();
    }

    public long uploadProtocol() {
        return this.stat[UPLOAD_PROTOCOL].total();
    }

    public long downloadProtocol() {
        return this.stat[DOWNLOAD_PROTOCOL].total();
    }

    public long uploadIPProtocol() {
        return this.stat[UPLOAD_IP_PROTOCOL].total();
    }

    public long downloadIPProtocol() {
        return this.stat[DOWNLOAD_IP_PROTOCOL].total();
    }

    public void clear() {
        for (int i = 0; i < NUM_CHANNELS; ++i) {
            this.stat[i].clear();
        }
    }
}

