/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.sha1_hash_vector;
import java.util.ArrayList;

public final class Sha1Hash
implements Comparable<Sha1Hash> {
    private final sha1_hash h;

    public Sha1Hash(sha1_hash h) {
        this.h = h;
    }

    public Sha1Hash(byte[] bytes) {
        if (bytes.length != 20) {
            throw new IllegalArgumentException("bytes array must be of length 20");
        }
        this.h = new sha1_hash(Vectors.bytes2byte_vector(bytes));
    }

    public Sha1Hash(String hex) {
        this();
        if (!sha1_hash.from_hex(hex, this.h)) {
            throw new IllegalArgumentException("Invalid sha1 hex string");
        }
    }

    public Sha1Hash() {
        this(new sha1_hash());
    }

    public sha1_hash swig() {
        return this.h;
    }

    public void clear() {
        this.h.clear();
    }

    public boolean isAllZeros() {
        return this.h.is_all_zeros();
    }

    public byte[] toBytes() {
        return Vectors.byte_vector2bytes(this.h.to_bytes());
    }

    public String toHex() {
        return this.h.to_hex();
    }

    @Override
    public int compareTo(Sha1Hash o) {
        return Sha1Hash.compare(this, o);
    }

    public String toString() {
        return this.toHex();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sha1Hash)) {
            return false;
        }
        return this.h.op_eq(((Sha1Hash)obj).h);
    }

    public int hashCode() {
        return this.h.hash_code();
    }

    public static Sha1Hash max() {
        return new Sha1Hash(sha1_hash.max());
    }

    public static Sha1Hash min() {
        return new Sha1Hash(sha1_hash.min());
    }

    public static int compare(Sha1Hash h1, Sha1Hash h2) {
        return sha1_hash.compare(h1.h, h2.h);
    }

    static ArrayList<Sha1Hash> convert(sha1_hash_vector v) {
        int size = (int)v.size();
        ArrayList<Sha1Hash> l = new ArrayList<Sha1Hash>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new Sha1Hash(v.get(i)));
        }
        return l;
    }
}

