/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.alerts;

import com.frostwire.jlibtorrent.alerts.AddTorrentAlert;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AnonymousModeAlert;
import com.frostwire.jlibtorrent.alerts.BlockDownloadingAlert;
import com.frostwire.jlibtorrent.alerts.BlockFinishedAlert;
import com.frostwire.jlibtorrent.alerts.BlockTimeoutAlert;
import com.frostwire.jlibtorrent.alerts.CacheFlushedAlert;
import com.frostwire.jlibtorrent.alerts.DhtAnnounceAlert;
import com.frostwire.jlibtorrent.alerts.DhtBootstrapAlert;
import com.frostwire.jlibtorrent.alerts.DhtDirectResponseAlert;
import com.frostwire.jlibtorrent.alerts.DhtErrorAlert;
import com.frostwire.jlibtorrent.alerts.DhtGetPeersAlert;
import com.frostwire.jlibtorrent.alerts.DhtGetPeersReplyAlert;
import com.frostwire.jlibtorrent.alerts.DhtImmutableItemAlert;
import com.frostwire.jlibtorrent.alerts.DhtLogAlert;
import com.frostwire.jlibtorrent.alerts.DhtMutableItemAlert;
import com.frostwire.jlibtorrent.alerts.DhtOutgoingGetPeersAlert;
import com.frostwire.jlibtorrent.alerts.DhtPktAlert;
import com.frostwire.jlibtorrent.alerts.DhtPutAlert;
import com.frostwire.jlibtorrent.alerts.DhtReplyAlert;
import com.frostwire.jlibtorrent.alerts.DhtStatsAlert;
import com.frostwire.jlibtorrent.alerts.ExternalIpAlert;
import com.frostwire.jlibtorrent.alerts.FastresumeRejectedAlert;
import com.frostwire.jlibtorrent.alerts.FileCompletedAlert;
import com.frostwire.jlibtorrent.alerts.FileErrorAlert;
import com.frostwire.jlibtorrent.alerts.FileRenameFailedAlert;
import com.frostwire.jlibtorrent.alerts.FileRenamedAlert;
import com.frostwire.jlibtorrent.alerts.GenericAlert;
import com.frostwire.jlibtorrent.alerts.HashFailedAlert;
import com.frostwire.jlibtorrent.alerts.I2pAlert;
import com.frostwire.jlibtorrent.alerts.IncomingConnectionAlert;
import com.frostwire.jlibtorrent.alerts.IncomingRequestAlert;
import com.frostwire.jlibtorrent.alerts.InvalidRequestAlert;
import com.frostwire.jlibtorrent.alerts.ListenFailedAlert;
import com.frostwire.jlibtorrent.alerts.ListenSucceededAlert;
import com.frostwire.jlibtorrent.alerts.LogAlert;
import com.frostwire.jlibtorrent.alerts.LsdErrorAlert;
import com.frostwire.jlibtorrent.alerts.LsdPeerAlert;
import com.frostwire.jlibtorrent.alerts.MetadataFailedAlert;
import com.frostwire.jlibtorrent.alerts.MetadataReceivedAlert;
import com.frostwire.jlibtorrent.alerts.MmapCacheAlert;
import com.frostwire.jlibtorrent.alerts.PeerAlert;
import com.frostwire.jlibtorrent.alerts.PeerBanAlert;
import com.frostwire.jlibtorrent.alerts.PeerBlockedAlert;
import com.frostwire.jlibtorrent.alerts.PeerConnectAlert;
import com.frostwire.jlibtorrent.alerts.PeerDisconnectedAlert;
import com.frostwire.jlibtorrent.alerts.PeerErrorAlert;
import com.frostwire.jlibtorrent.alerts.PeerLogAlert;
import com.frostwire.jlibtorrent.alerts.PeerSnubbedAlert;
import com.frostwire.jlibtorrent.alerts.PeerUnsnubbedAlert;
import com.frostwire.jlibtorrent.alerts.PerformanceAlert;
import com.frostwire.jlibtorrent.alerts.PickerLogAlert;
import com.frostwire.jlibtorrent.alerts.PieceFinishedAlert;
import com.frostwire.jlibtorrent.alerts.PortmapAlert;
import com.frostwire.jlibtorrent.alerts.PortmapErrorAlert;
import com.frostwire.jlibtorrent.alerts.PortmapLogAlert;
import com.frostwire.jlibtorrent.alerts.ReadPieceAlert;
import com.frostwire.jlibtorrent.alerts.RequestDroppedAlert;
import com.frostwire.jlibtorrent.alerts.SaveResumeDataAlert;
import com.frostwire.jlibtorrent.alerts.SaveResumeDataFailedAlert;
import com.frostwire.jlibtorrent.alerts.ScrapeFailedAlert;
import com.frostwire.jlibtorrent.alerts.ScrapeReplyAlert;
import com.frostwire.jlibtorrent.alerts.SessionStatsAlert;
import com.frostwire.jlibtorrent.alerts.StateChangedAlert;
import com.frostwire.jlibtorrent.alerts.StateUpdateAlert;
import com.frostwire.jlibtorrent.alerts.StatsAlert;
import com.frostwire.jlibtorrent.alerts.StorageMovedAlert;
import com.frostwire.jlibtorrent.alerts.StorageMovedFailedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentAddedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.alerts.TorrentCheckedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentDeleteFailedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentDeletedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentErrorAlert;
import com.frostwire.jlibtorrent.alerts.TorrentFinishedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentLogAlert;
import com.frostwire.jlibtorrent.alerts.TorrentNeedCertAlert;
import com.frostwire.jlibtorrent.alerts.TorrentPausedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentRemovedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentResumedAlert;
import com.frostwire.jlibtorrent.alerts.TorrentUpdateAlert;
import com.frostwire.jlibtorrent.alerts.TrackerAlert;
import com.frostwire.jlibtorrent.alerts.TrackerAnnounceAlert;
import com.frostwire.jlibtorrent.alerts.TrackerErrorAlert;
import com.frostwire.jlibtorrent.alerts.TrackerReplyAlert;
import com.frostwire.jlibtorrent.alerts.TrackerWarningAlert;
import com.frostwire.jlibtorrent.alerts.TrackeridAlert;
import com.frostwire.jlibtorrent.alerts.UdpErrorAlert;
import com.frostwire.jlibtorrent.alerts.UnwantedBlockAlert;
import com.frostwire.jlibtorrent.alerts.UrlSeedAlert;
import com.frostwire.jlibtorrent.swig.alert;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.peer_alert;
import com.frostwire.jlibtorrent.swig.torrent_alert;
import com.frostwire.jlibtorrent.swig.tracker_alert;

public final class Alerts {
    private static CastLambda[] TABLE = Alerts.buildTable();

    private Alerts() {
    }

    public static Alert cast(alert a) {
        return TABLE[a.type()].cast(a);
    }

    private static CastLambda[] buildTable() {
        CastLambda[] arr = new CastLambda[libtorrent.num_alert_types];
        arr[0] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentAlert<torrent_alert>(alert.cast_to_torrent_alert(a));
            }
        };
        arr[1] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerAlert<peer_alert>(alert.cast_to_peer_alert(a));
            }
        };
        arr[2] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackerAlert<tracker_alert>(alert.cast_to_tracker_alert(a));
            }
        };
        arr[3] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentAddedAlert(alert.cast_to_torrent_added_alert(a));
            }
        };
        arr[4] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentRemovedAlert(alert.cast_to_torrent_removed_alert(a));
            }
        };
        arr[5] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ReadPieceAlert(alert.cast_to_read_piece_alert(a));
            }
        };
        arr[6] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new FileCompletedAlert(alert.cast_to_file_completed_alert(a));
            }
        };
        arr[7] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new FileRenamedAlert(alert.cast_to_file_renamed_alert(a));
            }
        };
        arr[8] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new FileRenameFailedAlert(alert.cast_to_file_rename_failed_alert(a));
            }
        };
        arr[9] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PerformanceAlert(alert.cast_to_performance_alert(a));
            }
        };
        arr[10] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new StateChangedAlert(alert.cast_to_state_changed_alert(a));
            }
        };
        arr[11] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackerErrorAlert(alert.cast_to_tracker_error_alert(a));
            }
        };
        arr[12] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackerWarningAlert(alert.cast_to_tracker_warning_alert(a));
            }
        };
        arr[13] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ScrapeReplyAlert(alert.cast_to_scrape_reply_alert(a));
            }
        };
        arr[14] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ScrapeFailedAlert(alert.cast_to_scrape_failed_alert(a));
            }
        };
        arr[15] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackerReplyAlert(alert.cast_to_tracker_reply_alert(a));
            }
        };
        arr[16] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtReplyAlert(alert.cast_to_dht_reply_alert(a));
            }
        };
        arr[17] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackerAnnounceAlert(alert.cast_to_tracker_announce_alert(a));
            }
        };
        arr[18] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new HashFailedAlert(alert.cast_to_hash_failed_alert(a));
            }
        };
        arr[19] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerBanAlert(alert.cast_to_peer_ban_alert(a));
            }
        };
        arr[20] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerUnsnubbedAlert(alert.cast_to_peer_unsnubbed_alert(a));
            }
        };
        arr[21] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerSnubbedAlert(alert.cast_to_peer_snubbed_alert(a));
            }
        };
        arr[22] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerErrorAlert(alert.cast_to_peer_error_alert(a));
            }
        };
        arr[23] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerConnectAlert(alert.cast_to_peer_connect_alert(a));
            }
        };
        arr[24] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerDisconnectedAlert(alert.cast_to_peer_disconnected_alert(a));
            }
        };
        arr[25] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new InvalidRequestAlert(alert.cast_to_invalid_request_alert(a));
            }
        };
        arr[26] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentFinishedAlert(alert.cast_to_torrent_finished_alert(a));
            }
        };
        arr[27] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PieceFinishedAlert(alert.cast_to_piece_finished_alert(a));
            }
        };
        arr[28] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new RequestDroppedAlert(alert.cast_to_request_dropped_alert(a));
            }
        };
        arr[29] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new BlockTimeoutAlert(alert.cast_to_block_timeout_alert(a));
            }
        };
        arr[30] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new BlockFinishedAlert(alert.cast_to_block_finished_alert(a));
            }
        };
        arr[31] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new BlockDownloadingAlert(alert.cast_to_block_downloading_alert(a));
            }
        };
        arr[32] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new UnwantedBlockAlert(alert.cast_to_unwanted_block_alert(a));
            }
        };
        arr[33] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new StorageMovedAlert(alert.cast_to_storage_moved_alert(a));
            }
        };
        arr[34] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new StorageMovedFailedAlert(alert.cast_to_storage_moved_failed_alert(a));
            }
        };
        arr[35] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentDeletedAlert(alert.cast_to_torrent_deleted_alert(a));
            }
        };
        arr[36] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentDeleteFailedAlert(alert.cast_to_torrent_delete_failed_alert(a));
            }
        };
        arr[37] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new SaveResumeDataAlert(alert.cast_to_save_resume_data_alert(a));
            }
        };
        arr[38] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new SaveResumeDataFailedAlert(alert.cast_to_save_resume_data_failed_alert(a));
            }
        };
        arr[39] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentPausedAlert(alert.cast_to_torrent_paused_alert(a));
            }
        };
        arr[40] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentResumedAlert(alert.cast_to_torrent_resumed_alert(a));
            }
        };
        arr[41] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentCheckedAlert(alert.cast_to_torrent_checked_alert(a));
            }
        };
        arr[42] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new UrlSeedAlert(alert.cast_to_url_seed_alert(a));
            }
        };
        arr[43] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new FileErrorAlert(alert.cast_to_file_error_alert(a));
            }
        };
        arr[44] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new MetadataFailedAlert(alert.cast_to_metadata_failed_alert(a));
            }
        };
        arr[45] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new MetadataReceivedAlert(alert.cast_to_metadata_received_alert(a));
            }
        };
        arr[46] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new UdpErrorAlert(alert.cast_to_udp_error_alert(a));
            }
        };
        arr[47] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ExternalIpAlert(alert.cast_to_external_ip_alert(a));
            }
        };
        arr[48] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ListenFailedAlert(alert.cast_to_listen_failed_alert(a));
            }
        };
        arr[49] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new ListenSucceededAlert(alert.cast_to_listen_succeeded_alert(a));
            }
        };
        arr[50] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PortmapErrorAlert(alert.cast_to_portmap_error_alert(a));
            }
        };
        arr[51] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PortmapAlert(alert.cast_to_portmap_alert(a));
            }
        };
        arr[52] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PortmapLogAlert(alert.cast_to_portmap_log_alert(a));
            }
        };
        arr[53] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new FastresumeRejectedAlert(alert.cast_to_fastresume_rejected_alert(a));
            }
        };
        arr[54] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerBlockedAlert(alert.cast_to_peer_blocked_alert(a));
            }
        };
        arr[55] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtAnnounceAlert(alert.cast_to_dht_announce_alert(a));
            }
        };
        arr[56] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtGetPeersAlert(alert.cast_to_dht_get_peers_alert(a));
            }
        };
        arr[57] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new StatsAlert(alert.cast_to_stats_alert(a));
            }
        };
        arr[58] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new CacheFlushedAlert(alert.cast_to_cache_flushed_alert(a));
            }
        };
        arr[59] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new AnonymousModeAlert(alert.cast_to_anonymous_mode_alert(a));
            }
        };
        arr[60] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new LsdPeerAlert(alert.cast_to_lsd_peer_alert(a));
            }
        };
        arr[61] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TrackeridAlert(alert.cast_to_trackerid_alert(a));
            }
        };
        arr[62] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtBootstrapAlert(alert.cast_to_dht_bootstrap_alert(a));
            }
        };
        arr[63] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new GenericAlert(a);
            }
        };
        arr[64] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentErrorAlert(alert.cast_to_torrent_error_alert(a));
            }
        };
        arr[65] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentNeedCertAlert(alert.cast_to_torrent_need_cert_alert(a));
            }
        };
        arr[66] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new IncomingConnectionAlert(alert.cast_to_incoming_connection_alert(a));
            }
        };
        arr[67] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new AddTorrentAlert(alert.cast_to_add_torrent_alert(a));
            }
        };
        arr[68] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new StateUpdateAlert(alert.cast_to_state_update_alert(a));
            }
        };
        arr[69] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new MmapCacheAlert(alert.cast_to_mmap_cache_alert(a));
            }
        };
        arr[70] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new SessionStatsAlert(alert.cast_to_session_stats_alert(a));
            }
        };
        arr[71] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentUpdateAlert(alert.cast_to_torrent_update_alert(a));
            }
        };
        arr[72] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new GenericAlert(a);
            }
        };
        arr[73] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtErrorAlert(alert.cast_to_dht_error_alert(a));
            }
        };
        arr[74] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtImmutableItemAlert(alert.cast_to_dht_immutable_item_alert(a));
            }
        };
        arr[75] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtMutableItemAlert(alert.cast_to_dht_mutable_item_alert(a));
            }
        };
        arr[76] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtPutAlert(alert.cast_to_dht_put_alert(a));
            }
        };
        arr[77] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new I2pAlert(alert.cast_to_i2p_alert(a));
            }
        };
        arr[78] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtOutgoingGetPeersAlert(alert.cast_to_dht_outgoing_get_peers_alert(a));
            }
        };
        arr[79] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new LogAlert(alert.cast_to_log_alert(a));
            }
        };
        arr[80] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new TorrentLogAlert(alert.cast_to_torrent_log_alert(a));
            }
        };
        arr[81] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PeerLogAlert(alert.cast_to_peer_log_alert(a));
            }
        };
        arr[82] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new LsdErrorAlert(alert.cast_to_lsd_error_alert(a));
            }
        };
        arr[83] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtStatsAlert(alert.cast_to_dht_stats_alert(a));
            }
        };
        arr[84] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new IncomingRequestAlert(alert.cast_to_incoming_request_alert(a));
            }
        };
        arr[85] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtLogAlert(alert.cast_to_dht_log_alert(a));
            }
        };
        arr[86] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtPktAlert(alert.cast_to_dht_pkt_alert(a));
            }
        };
        arr[87] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtGetPeersReplyAlert(alert.cast_to_dht_get_peers_reply_alert(a));
            }
        };
        arr[88] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new DhtDirectResponseAlert(alert.cast_to_dht_direct_response_alert(a));
            }
        };
        arr[89] = new CastLambda(){

            @Override
            public Alert cast(alert a) {
                return new PickerLogAlert(alert.cast_to_picker_log_alert(a));
            }
        };
        return arr;
    }

    private static interface CastLambda {
        public Alert cast(alert var1);
    }
}

