/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.plugins;

import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.DhtSettings;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.plugins.DhtStorage;
import com.frostwire.jlibtorrent.swig.address;
import com.frostwire.jlibtorrent.swig.bloom_filter_128;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.tcp_endpoint;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DhtStorageBase
implements DhtStorage {
    private final Sha1Hash id;
    private final DhtSettings settings;
    private final DhtStorage.Counters counters;
    private final boolean print;
    private final HashMap<Sha1Hash, TorrentEntry> torrents;
    private final HashMap<Sha1Hash, DhtImmutableItem> immutables;
    private final HashMap<Sha1Hash, DhtMutableItem> mutables;

    public DhtStorageBase(Sha1Hash id, DhtSettings settings, boolean print) {
        this.id = id;
        this.settings = settings;
        this.counters = new DhtStorage.Counters();
        this.print = print;
        this.torrents = new HashMap();
        this.immutables = new HashMap();
        this.mutables = new HashMap();
    }

    public DhtStorageBase(Sha1Hash id, DhtSettings settings) {
        this(id, settings, false);
    }

    @Override
    public boolean getPeers(Sha1Hash infoHash, boolean noseed, boolean scrape, entry peers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void announcePeer(Sha1Hash infoHash, TcpEndpoint endp, String name, boolean seed) {
        TorrentEntry v = this.torrents.get(infoHash);
        if (v == null) {
            if (!this.torrents.isEmpty() && this.torrents.size() >= this.settings.maxTorrents()) {
                int num_peers = Integer.MAX_VALUE;
                Sha1Hash candidateKey = null;
                for (Map.Entry<Sha1Hash, TorrentEntry> kv : this.torrents.entrySet()) {
                    if (kv.getValue().peers.size() > num_peers || infoHash.equals(kv.getKey())) continue;
                    num_peers = kv.getValue().peers.size();
                    candidateKey = kv.getKey();
                }
                this.torrents.remove(candidateKey);
                this.counters.peers -= num_peers;
                --this.counters.torrents;
            }
            ++this.counters.torrents;
            v = new TorrentEntry();
            this.torrents.put(infoHash, v);
        }
        if (!name.isEmpty() && v.name.isEmpty()) {
            String tname = name;
            if (tname.length() > 100) {
                tname = tname.substring(0, 99);
            }
            v.name = tname;
        }
        PeerEntry peer = new PeerEntry();
        peer.addr = endp.swig();
        peer.added = System.currentTimeMillis();
        peer.seed = seed;
        if (v.peers.contains(peer)) {
            v.peers.remove(peer);
            --this.counters.peers;
        } else if (v.peers.size() >= this.settings.maxPeers()) {
            if (Math.random() > 0.5) {
                return;
            }
            PeerEntry t = v.peers.lower(peer);
            if (t == null) {
                t = v.peers.first();
            }
            v.peers.remove(t);
            --this.counters.peers;
        }
        v.peers.add(peer);
        ++this.counters.peers;
        if (this.print) {
            DhtStorageBase.print("announce_peer", "Name: " + name);
        }
    }

    @Override
    public boolean getImmutableItem(Sha1Hash target, entry item) {
        DhtImmutableItem i = this.immutables.get(target);
        if (i == null) {
            return false;
        }
        item.set("v", entry.bdecode(Vectors.bytes2byte_vector(i.value)));
        if (this.print) {
            DhtStorageBase.print("get_immutable_item", item);
        }
        return true;
    }

    @Override
    public void putImmutableItem(Sha1Hash target, byte[] buf, Address addr) {
        DhtImmutableItem i = this.immutables.get(target);
        if (i == null) {
            if (this.immutables.size() >= this.settings.maxDhtItems()) {
                Map.Entry<Sha1Hash, DhtImmutableItem> j = Collections.min(this.immutables.entrySet(), new ImmutableItemComparator(this.id));
                this.immutables.remove(j.getKey());
                --this.counters.immutable_data;
            }
            i = new DhtImmutableItem();
            i.value = buf;
            i.ips = new bloom_filter_128();
            this.immutables.put(target, i);
            ++this.counters.immutable_data;
        }
        DhtStorageBase.touchItem(i, addr.swig());
        if (this.print) {
            DhtStorageBase.print("put_immutable_item", "From: " + addr);
        }
    }

    @Override
    public long getMutableItemSeq(Sha1Hash target) {
        DhtMutableItem i = this.mutables.get(target);
        return i != null ? i.seq : -1L;
    }

    @Override
    public boolean getMutableItem(Sha1Hash target, long seq, boolean forceFill, entry item) {
        DhtMutableItem f = this.mutables.get(target);
        if (f == null) {
            return false;
        }
        item.set("seq", f.seq);
        if (forceFill || 0L <= seq && seq < f.seq) {
            item.set("v", entry.bdecode(Vectors.bytes2byte_vector(f.value)));
            item.set("sig", Vectors.bytes2byte_vector(f.sig));
            item.set("k", Vectors.bytes2byte_vector(f.key));
        }
        if (this.print) {
            DhtStorageBase.print("get_mutable_item", item);
        }
        return true;
    }

    @Override
    public void putMutableItem(Sha1Hash target, byte[] buf, byte[] sig, long seq, byte[] pk, byte[] salt, Address addr) {
        DhtMutableItem i = this.mutables.get(target);
        if (i == null) {
            if (this.mutables.size() >= this.settings.maxDhtItems()) {
                Map.Entry<Sha1Hash, DhtMutableItem> j = Collections.min(this.mutables.entrySet(), new Comparator<Map.Entry<Sha1Hash, DhtMutableItem>>(){

                    @Override
                    public int compare(Map.Entry<Sha1Hash, DhtMutableItem> o1, Map.Entry<Sha1Hash, DhtMutableItem> o2) {
                        return Integer.compare(o1.getValue().num_announcers, o2.getValue().num_announcers);
                    }
                });
                this.mutables.remove(j.getKey());
                --this.counters.mutable_data;
            }
            i = new DhtMutableItem();
            i.value = buf;
            i.ips = new bloom_filter_128();
            i.seq = seq;
            i.salt = salt;
            i.sig = sig;
            i.key = pk;
            this.mutables.put(target, i);
            ++this.counters.mutable_data;
        } else {
            DhtMutableItem item = i;
            if (item.seq < seq) {
                item.seq = seq;
                item.value = buf;
            }
        }
        DhtStorageBase.touchItem(i, addr.swig());
        if (this.print) {
            DhtStorageBase.print("put_mutable_item", "From: " + addr);
        }
    }

    @Override
    public void tick() {
        long now = System.currentTimeMillis();
        Iterator<TorrentEntry> torrentsIt = this.torrents.values().iterator();
        while (torrentsIt.hasNext()) {
            TorrentEntry t = torrentsIt.next();
            this.purgePeers(t.peers);
            if (!t.peers.isEmpty()) continue;
            torrentsIt.remove();
            --this.counters.torrents;
        }
        if (0 == this.settings.itemLifetime()) {
            return;
        }
        int lifetime = this.settings.itemLifetime();
        if (lifetime < 7200) {
            lifetime = 7200;
        }
        Iterator<DhtImmutableItem> immutablesIt = this.immutables.values().iterator();
        while (immutablesIt.hasNext()) {
            DhtImmutableItem i = immutablesIt.next();
            if (i.last_seen + (long)(lifetime * 1000) > now) continue;
            immutablesIt.remove();
            --this.counters.immutable_data;
        }
        Iterator<DhtMutableItem> mutablesIt = this.mutables.values().iterator();
        while (mutablesIt.hasNext()) {
            DhtMutableItem i = mutablesIt.next();
            if (i.last_seen + (long)(lifetime * 1000) > now) continue;
            mutablesIt.remove();
            --this.counters.mutable_data;
        }
    }

    @Override
    public DhtStorage.Counters counters() {
        return this.counters;
    }

    private void purgePeers(Set<PeerEntry> peers) {
        int announce_interval = 30;
        Iterator<PeerEntry> it = peers.iterator();
        while (it.hasNext()) {
            PeerEntry i = it.next();
            if (!((float)i.added + (float)announce_interval * 1.5f * 60.0f * 1000.0f < (float)System.currentTimeMillis())) continue;
            it.remove();
            --this.counters.peers;
        }
    }

    private static void print(String operation, entry entry2) {
        System.out.println("DHT OP: " + operation);
        System.out.println(entry2.to_string());
    }

    private static void print(String operation, String msg) {
        System.out.println("DHT OP: " + operation);
        System.out.println(msg);
    }

    private static void touchItem(DhtImmutableItem f, address address2) {
        throw new UnsupportedOperationException();
    }

    private static final class ImmutableItemComparator
    implements Comparator<Map.Entry<Sha1Hash, DhtImmutableItem>> {
        private final Sha1Hash ourId;

        public ImmutableItemComparator(Sha1Hash ourId) {
            this.ourId = ourId;
        }

        @Override
        public int compare(Map.Entry<Sha1Hash, DhtImmutableItem> lhs, Map.Entry<Sha1Hash, DhtImmutableItem> rhs) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DhtMutableItem
    extends DhtImmutableItem {
        public byte[] sig;
        public long seq;
        public byte[] key;
        public byte[] salt;

        private DhtMutableItem() {
        }
    }

    private static class DhtImmutableItem {
        public byte[] value;
        public bloom_filter_128 ips;
        public long last_seen;
        public int num_announcers;

        private DhtImmutableItem() {
        }
    }

    private static final class TorrentEntry {
        public String name = "";
        public TreeSet<PeerEntry> peers = new TreeSet<PeerEntry>(PeerEntry.COMPARATOR);
    }

    private static final class PeerEntry {
        public long added;
        public tcp_endpoint addr;
        public boolean seed;
        public static final Comparator<PeerEntry> COMPARATOR = new Comparator<PeerEntry>(){

            @Override
            public int compare(PeerEntry o1, PeerEntry o2) {
                tcp_endpoint a1 = o1.addr;
                tcp_endpoint a2 = o2.addr;
                int r = address.compare(a1.address(), a2.address());
                return r == 0 ? Integer.compare(a1.port(), a2.port()) : r;
            }
        };

        private PeerEntry() {
        }
    }
}

