/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.plugins;

import com.frostwire.jlibtorrent.AddTorrentParams;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.PeerConnectionHandle;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.alerts.Alerts;
import com.frostwire.jlibtorrent.plugins.DhtPlugin;
import com.frostwire.jlibtorrent.plugins.Plugin;
import com.frostwire.jlibtorrent.plugins.SwigDhtPlugin;
import com.frostwire.jlibtorrent.plugins.SwigTorrentPlugin;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.alert;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.peer_connection_handle;
import com.frostwire.jlibtorrent.swig.session_handle;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.string_dht_extension_handler_listener_ptr_pair;
import com.frostwire.jlibtorrent.swig.string_dht_extension_handler_listener_ptr_pair_vector;
import com.frostwire.jlibtorrent.swig.swig_plugin;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class SwigPlugin
extends swig_plugin {
    private static final Logger LOG = Logger.getLogger(SwigPlugin.class);
    private final Plugin p;
    private final List<SwigTorrentPlugin> mem;
    private final Object memLock;
    private final List<SwigDhtPlugin> memDht;

    public SwigPlugin(Plugin p) {
        this.p = p;
        this.mem = new LinkedList<SwigTorrentPlugin>();
        this.memLock = new Object();
        this.memDht = new LinkedList<SwigDhtPlugin>();
    }

    @Override
    public void added(session_handle s) {
        try {
            this.p.added(new SessionHandle(s));
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (added)", e);
        }
    }

    @Override
    public void register_dht_extensions(string_dht_extension_handler_listener_ptr_pair_vector dht_extensions) {
        try {
            if (this.p.handleOperation(Plugin.Operation.REGISTER_DHT_EXTENSIONS)) {
                LinkedList<Pair<String, DhtPlugin>> plugins = new LinkedList<Pair<String, DhtPlugin>>();
                this.p.registerDhtPlugins(plugins);
                for (Pair pair : plugins) {
                    String q = (String)pair.first;
                    SwigDhtPlugin h = this.pin(new SwigDhtPlugin((DhtPlugin)pair.second));
                    string_dht_extension_handler_listener_ptr_pair pair2 = new string_dht_extension_handler_listener_ptr_pair(q, h);
                    dht_extensions.push_back(pair2);
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (register_dht_extensions)", e);
        }
    }

    @Override
    public void on_alert(alert a) {
        try {
            if (this.p.handleOperation(Plugin.Operation.ON_ALERT)) {
                this.p.onAlert(Alerts.cast(a));
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_alert)", e);
        }
    }

    @Override
    public boolean on_unknown_torrent(sha1_hash info_hash, peer_connection_handle pc, add_torrent_params p) {
        try {
            if (this.p.handleOperation(Plugin.Operation.ON_UNKNOWN_TORRENT)) {
                return this.p.onUnknownTorrent(new Sha1Hash(info_hash), new PeerConnectionHandle(pc), new AddTorrentParams(p));
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_unknown_torrent)", e);
        }
        return false;
    }

    @Override
    public void on_tick() {
        try {
            this.p.onTick();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_tick)", e);
        }
        this.cleanup();
    }

    @Override
    public void save_state(entry e) {
        try {
            if (this.p.handleOperation(Plugin.Operation.SAVE_STATE)) {
                this.p.saveState(new Entry(e));
            }
        }
        catch (Throwable t) {
            LOG.error("Error in plugin (save_state)", t);
        }
    }

    @Override
    public void load_state(bdecode_node n) {
        try {
            if (this.p.handleOperation(Plugin.Operation.LOAD_STATE)) {
                this.p.loadState(n);
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (load_state)", e);
        }
    }

    private SwigTorrentPlugin pin(SwigTorrentPlugin p) {
        this.mem.add(p);
        return p;
    }

    private SwigDhtPlugin pin(SwigDhtPlugin p) {
        this.memDht.add(p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.memLock;
        synchronized (object) {
            Iterator<SwigTorrentPlugin> it = this.mem.iterator();
            while (it.hasNext()) {
                SwigTorrentPlugin p = it.next();
                if (p.t.is_valid()) continue;
                it.remove();
            }
        }
    }
}

