/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.plugins;

import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.plugins.SwigPeerPlugin;
import com.frostwire.jlibtorrent.plugins.TorrentPlugin;
import com.frostwire.jlibtorrent.swig.swig_torrent_plugin;
import com.frostwire.jlibtorrent.swig.tcp_endpoint;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import java.util.LinkedList;
import java.util.List;

public final class SwigTorrentPlugin
extends swig_torrent_plugin {
    private static final Logger LOG = Logger.getLogger(SwigTorrentPlugin.class);
    private final TorrentPlugin p;
    final torrent_handle t;
    private final List<SwigPeerPlugin> mem;

    public SwigTorrentPlugin(TorrentPlugin p, torrent_handle t) {
        this.p = p;
        this.t = t;
        this.mem = new LinkedList<SwigPeerPlugin>();
    }

    @Override
    public void on_piece_pass(int index) {
        try {
            this.p.onPiecePass(index);
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_piece_pass)", e);
        }
    }

    @Override
    public void on_piece_failed(int index) {
        try {
            this.p.onPieceFailed(index);
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_piece_failed)", e);
        }
    }

    @Override
    public void tick() {
        try {
            this.p.tick();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (tick)", e);
        }
    }

    @Override
    public boolean on_pause() {
        try {
            return this.p.onPause();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_pause)", e);
            return false;
        }
    }

    @Override
    public boolean on_resume() {
        try {
            return this.p.onResume();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_resume)", e);
            return false;
        }
    }

    @Override
    public void on_files_checked() {
        try {
            this.p.onFilesChecked();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_files_checked)", e);
        }
    }

    @Override
    public void on_state(int s) {
        try {
            if (this.p.handleOperation(TorrentPlugin.Operation.ON_STATE)) {
                this.p.onState(TorrentStatus.State.fromSwig(s));
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_state)", e);
        }
    }

    @Override
    public void on_unload() {
        try {
            this.p.onUnload();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_unload)", e);
        }
    }

    @Override
    public void on_load() {
        try {
            this.p.onLoad();
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_load)", e);
        }
    }

    @Override
    public void on_add_peer(tcp_endpoint endp, int src, int flags) {
        try {
            if (this.p.handleOperation(TorrentPlugin.Operation.ON_ADD_PEER)) {
                this.p.onAddPeer(new TcpEndpoint(endp), src, TorrentPlugin.Flags.fromSwig(flags));
            }
        }
        catch (Throwable e) {
            LOG.error("Error in plugin (on_add_peer)", e);
        }
    }

    private SwigPeerPlugin pin(SwigPeerPlugin p) {
        this.mem.add(p);
        return p;
    }
}

