/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.Ed25519;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Session;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.DhtGetPeersReplyAlert;
import com.frostwire.jlibtorrent.alerts.DhtImmutableItemAlert;
import com.frostwire.jlibtorrent.alerts.DhtMutableItemAlert;
import com.frostwire.jlibtorrent.swig.settings_pack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Dht {
    private static final int[] DHT_IMMUTABLE_ITEM_TYPES = new int[]{AlertType.DHT_IMMUTABLE_ITEM.swig()};
    private static final int[] DHT_MUTABLE_ITEM_TYPES = new int[]{AlertType.DHT_MUTABLE_ITEM.swig()};
    private static final int[] DHT_GET_PEERS_REPLY_ALERT_TYPES = new int[]{AlertType.DHT_GET_PEERS_REPLY.swig()};
    private final Session s;

    public Dht(Session s) {
        this.s = s;
    }

    public void start() {
        this.toggleDHT(true);
    }

    public void stop() {
        this.toggleDHT(false);
    }

    public boolean running() {
        return this.s.isDHTRunning();
    }

    public Entry get(Sha1Hash sha1, int timeout) {
        final Sha1Hash target = sha1;
        final Entry[] result = new Entry[]{null};
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener l = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_IMMUTABLE_ITEM_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                DhtImmutableItemAlert itemAlert;
                if (alert2 instanceof DhtImmutableItemAlert && target.equals((itemAlert = (DhtImmutableItemAlert)alert2).getTarget())) {
                    result[0] = itemAlert.getItem();
                    signal.countDown();
                }
            }
        };
        this.s.addListener(l);
        this.s.dhtGetItem(target);
        try {
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.s.removeListener(l);
        return result[0];
    }

    public Sha1Hash put(Entry entry2) {
        return this.s.dhtPutItem(entry2);
    }

    public ArrayList<TcpEndpoint> getPeers(Sha1Hash sha1, int timeout) {
        final Sha1Hash target = sha1;
        final ArrayList<TcpEndpoint> result = new ArrayList<TcpEndpoint>();
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener l = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_GET_PEERS_REPLY_ALERT_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                DhtGetPeersReplyAlert replyAlert;
                if (alert2 instanceof DhtGetPeersReplyAlert && target.equals((replyAlert = (DhtGetPeersReplyAlert)alert2).infoHash())) {
                    result.addAll(replyAlert.peers());
                    signal.countDown();
                }
            }
        };
        this.s.addListener(l);
        this.s.dhtGetPeers(target);
        try {
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.s.removeListener(l);
        return result;
    }

    public void announce(Sha1Hash sha1, int port, int flags) {
        this.s.dhtAnnounce(sha1, port, flags);
    }

    public void announce(Sha1Hash sha1) {
        this.s.dhtAnnounce(sha1);
    }

    public MutableItem mget(final byte[] key, final byte[] salt, int timeout) {
        final MutableItem[] result = new MutableItem[]{null};
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener l = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_MUTABLE_ITEM_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                if (alert2 instanceof DhtMutableItemAlert) {
                    DhtMutableItemAlert itemAlert = (DhtMutableItemAlert)alert2;
                    boolean sameKey = Arrays.equals(key, itemAlert.key());
                    boolean sameSalt = Arrays.equals(salt, itemAlert.salt());
                    if (sameKey && sameSalt) {
                        MutableItem item;
                        result[0] = item = new MutableItem(itemAlert.item(), itemAlert.signature(), itemAlert.seq());
                        signal.countDown();
                    }
                }
            }
        };
        this.s.addListener(l);
        this.s.dhtGetItem(key, salt);
        try {
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.s.removeListener(l);
        return result[0];
    }

    public void mput(byte[] publicKey, byte[] privateKey, Entry entry2, byte[] salt) {
        this.s.dhtPutItem(publicKey, privateKey, entry2, salt);
    }

    public static byte[][] createKeypair() {
        byte[] seed = new byte[Ed25519.SEED_SIZE];
        Ed25519.createSeed(seed);
        byte[] publicKey = new byte[Ed25519.PUBLIC_KEY_SIZE];
        byte[] privateKey = new byte[Ed25519.PRIVATE_KEY_SIZE];
        Ed25519.createKeypair(publicKey, privateKey, seed);
        byte[][] keys = new byte[][]{publicKey, privateKey};
        return keys;
    }

    private void toggleDHT(boolean on) {
        SettingsPack pack = new SettingsPack();
        pack.setBoolean(settings_pack.bool_types.enable_dht.swigValue(), on);
        this.s.applySettings(pack);
    }

    public static final class MutableItem {
        public final Entry item;
        public final byte[] signature;
        public final long seq;

        private MutableItem(Entry item, byte[] signature, long seq) {
            this.item = item;
            this.signature = signature;
            this.seq = seq;
        }
    }
}

