/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.BlockInfo;
import com.frostwire.jlibtorrent.swig.block_info_vector;
import com.frostwire.jlibtorrent.swig.partial_piece_info;
import java.util.ArrayList;

public final class PartialPieceInfo {
    private final partial_piece_info p;

    public PartialPieceInfo(partial_piece_info p) {
        this.p = p;
    }

    public partial_piece_info swig() {
        return this.p;
    }

    public int pieceIndex() {
        return this.p.getPiece_index();
    }

    public int blocksInPiece() {
        return this.p.getBlocks_in_piece();
    }

    public int finished() {
        return this.p.getFinished();
    }

    public int writing() {
        return this.p.getWriting();
    }

    public int requested() {
        return this.p.getRequested();
    }

    public ArrayList<BlockInfo> blocks() {
        block_info_vector v = this.p.get_blocks();
        int size = (int)v.size();
        ArrayList<BlockInfo> l = new ArrayList<BlockInfo>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new BlockInfo(v.get(i)));
        }
        return l;
    }

    public State pieceState() {
        return State.fromSwig(this.p.getPiece_state().swigValue());
    }

    public static enum State {
        NONE(partial_piece_info.state_t.none.swigValue()),
        SLOW(partial_piece_info.state_t.slow.swigValue()),
        MEDIUM(partial_piece_info.state_t.medium.swigValue()),
        FAST(partial_piece_info.state_t.fast.swigValue()),
        UNKNOWN(-1);

        private final int swigValue;

        private State(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }

        public static State fromSwig(int swigValue) {
            State[] enumValues;
            for (State ev : enumValues = (State[])State.class.getEnumConstants()) {
                if (ev.swig() != swigValue) continue;
                return ev;
            }
            return UNKNOWN;
        }
    }
}

