/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.DhtSettings;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.JavaStat;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.LruCache;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.SessionProxy;
import com.frostwire.jlibtorrent.SessionStats;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.SparseArray;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.UdpEndpoint;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.Alerts;
import com.frostwire.jlibtorrent.alerts.MetadataReceivedAlert;
import com.frostwire.jlibtorrent.alerts.SessionStatsAlert;
import com.frostwire.jlibtorrent.plugins.Plugin;
import com.frostwire.jlibtorrent.plugins.SwigPlugin;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.alert;
import com.frostwire.jlibtorrent.swig.alert_ptr_vector;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.counters;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.session;
import com.frostwire.jlibtorrent.swig.settings_pack;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.storage_mode_t;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class Session
extends SessionHandle {
    private static final Logger LOG = Logger.getLogger(Session.class);
    private static final long REQUEST_STATS_RESOLUTION_MILLIS = 1000L;
    private static final long ALERTS_LOOP_WAIT_MILLIS = 500L;
    private static final LruCache<String, byte[]> MAGNET_CACHE = new LruCache(50);
    private static final Object MAGNET_LOCK = new Object();
    private final session s;
    private final JavaStat stat;
    private final SessionStats stats;
    private long lastStatsRequestTime;
    private long lastStatSecondTick;
    private final SparseArray<ArrayList<AlertListener>> listeners;
    private final SparseArray<AlertListener[]> listenerSnapshots;
    private boolean running;
    private final LinkedList<SwigPlugin> plugins;

    public Session(SettingsPack settings, boolean logging, AlertListener listener) {
        super(Session.createSession(settings, logging));
        this.s = (session)((SessionHandle)this).s;
        this.stat = new JavaStat();
        this.stats = new SessionStats(this.stat);
        this.listeners = new SparseArray();
        this.listenerSnapshots = new SparseArray();
        if (listener != null) {
            this.addListener(listener);
        }
        this.running = true;
        this.alertsLoop();
        for (Pair<String, Integer> router : Session.defaultRouters()) {
            this.s.add_dht_router(router.to_string_int_pair());
        }
        this.plugins = new LinkedList();
    }

    public Session() {
        this(new SettingsPack(), false, null);
    }

    public Session(String interfaces, int retries, boolean logging, AlertListener listener) {
        this(Session.createSettings(interfaces, retries), logging, listener);
    }

    public void addListener(AlertListener listener) {
        this.modifyListeners(true, listener);
    }

    public void removeListener(AlertListener listener) {
        this.modifyListeners(false, listener);
    }

    public TorrentHandle addTorrent(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile) {
        return this.addTorrentSupport(ti, saveDir, priorities, resumeFile, false);
    }

    public TorrentHandle addTorrent(File torrent, File saveDir, File resumeFile) {
        return this.addTorrent(new TorrentInfo(torrent), saveDir, null, resumeFile);
    }

    public TorrentHandle addTorrent(File torrent, File saveDir) {
        return this.addTorrent(torrent, saveDir, null);
    }

    public void asyncAddTorrent(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile) {
        this.addTorrentSupport(ti, saveDir, priorities, resumeFile, true);
    }

    public void asyncAddTorrent(File torrent, File saveDir, File resumeFile) {
        this.asyncAddTorrent(new TorrentInfo(torrent), saveDir, null, resumeFile);
    }

    public void asyncAddTorrent(File torrent, File saveDir) {
        this.asyncAddTorrent(torrent, saveDir, null);
    }

    public void removeTorrent(TorrentHandle th, SessionHandle.Options options) {
        this.s.remove_torrent(th.swig(), options.swig());
    }

    public void removeTorrent(TorrentHandle th) {
        if (th.isValid()) {
            this.s.remove_torrent(th.swig());
        }
    }

    public SessionProxy abort() {
        this.running = false;
        return new SessionProxy(this.s.abort());
    }

    public void destroy() {
        this.running = false;
        this.s.delete();
    }

    public void pause() {
        this.s.pause();
    }

    public void resume() {
        this.s.resume();
    }

    public boolean isPaused() {
        return this.s.is_paused();
    }

    public int getListenPort() {
        return this.s.listen_port();
    }

    public int getSslListenPort() {
        return this.s.ssl_listen_port();
    }

    public boolean isListening() {
        return this.s.is_listening();
    }

    public void postTorrentUpdates(TorrentHandle.StatusFlags flags) {
        this.s.post_torrent_updates(flags.getSwig());
    }

    public void postTorrentUpdates() {
        this.s.post_torrent_updates();
    }

    public void postSessionStats() {
        this.s.post_session_stats();
    }

    public void postDHTStats() {
        this.s.post_dht_stats();
    }

    void setDHTSettings(DhtSettings settings) {
        this.s.set_dht_settings(settings.swig());
    }

    public boolean isDHTRunning() {
        return this.s.is_dht_running();
    }

    public void addDHTNode(Pair<String, Integer> node) {
        this.s.add_dht_node(node.to_string_int_pair());
    }

    public void addDHTRouter(Pair<String, Integer> node) {
        this.s.add_dht_router(node.to_string_int_pair());
    }

    public void dhtGetItem(Sha1Hash target) {
        this.s.dht_get_item(target.swig());
    }

    public void dhtGetItem(byte[] key, byte[] salt) {
        this.s.dht_get_item(Vectors.bytes2byte_vector(key), Vectors.bytes2byte_vector(salt));
    }

    public Sha1Hash dhtPutItem(Entry entry2) {
        return new Sha1Hash(this.s.dht_put_item(entry2.swig()));
    }

    public void dhtPutItem(byte[] publicKey, byte[] privateKey, Entry entry2, byte[] salt) {
        this.s.dht_put_item(Vectors.bytes2byte_vector(publicKey), Vectors.bytes2byte_vector(privateKey), entry2.swig(), Vectors.bytes2byte_vector(salt));
    }

    public void dhtGetPeers(Sha1Hash infoHash) {
        this.s.dht_get_peers(infoHash.swig());
    }

    public void dhtAnnounce(Sha1Hash infoHash, int port, int flags) {
        this.s.dht_announce(infoHash.swig(), port, flags);
    }

    public void dhtAnnounce(Sha1Hash infoHash) {
        this.s.dht_announce(infoHash.swig());
    }

    public void dhtDirectRequest(UdpEndpoint endp, Entry entry2) {
        this.s.dht_direct_request(endp.swig(), entry2.swig());
    }

    public void addExtension(Plugin p) {
        SwigPlugin sp = new SwigPlugin(p);
        this.s.add_swig_extension(sp);
        this.plugins.add(sp);
    }

    public int addPortMapping(SessionHandle.ProtocolType t, int externalPort, int localPort) {
        return this.s.add_port_mapping(t.swig(), externalPort, localPort);
    }

    public void deletePortMapping(int handle) {
        this.s.delete_port_mapping(handle);
    }

    public SessionStats getStats() {
        return this.stats;
    }

    public SettingsPack getSettingsPack() {
        return new SettingsPack(this.s.get_settings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchMagnet(String uri, int timeout) {
        boolean add;
        torrent_handle th;
        add_torrent_params p = add_torrent_params.create_instance_disabled_storage();
        error_code ec = new error_code();
        libtorrent.parse_magnet_uri(uri, p, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
        sha1_hash info_hash = p.getInfo_hash();
        String sha1 = info_hash.to_hex();
        byte[] data = (byte[])MAGNET_CACHE.get(sha1);
        if (data != null) {
            return data;
        }
        Object object = MAGNET_LOCK;
        synchronized (object) {
            th = this.s.find_torrent(info_hash);
            add = th == null || !th.is_valid();
            if (add) {
                p.setName("fetch_magnet:" + uri);
                p.setSave_path("fetch_magnet/" + uri);
                long flags = p.get_flags();
                p.set_flags(flags &= (long)(~add_torrent_params.flags_t.flag_auto_managed.swigValue()));
                ec.clear();
                th = this.s.add_torrent(p, ec);
                th.resume();
            }
        }
        int n = 0;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            data = (byte[])MAGNET_CACHE.get(sha1);
        } while (++n < timeout && data == null);
        Object object2 = MAGNET_LOCK;
        synchronized (object2) {
            if (add && th != null && th.is_valid()) {
                this.s.remove_torrent(th);
            }
        }
        return data;
    }

    protected void finalize() throws Throwable {
        this.running = false;
        super.finalize();
    }

    private void fireAlert(Alert<?> a, int type) {
        AlertListener[] listeners = this.listenerSnapshots.get(type);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    AlertListener l = listeners[i];
                    if (l == null) continue;
                    l.alert(a);
                    continue;
                }
                catch (Throwable e) {
                    LOG.warn("Error calling alert listener", e);
                }
            }
        }
    }

    private TorrentHandle addTorrentSupport(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile, boolean async) {
        return this.addTorrentSupport(ti, saveDir, priorities, resumeFile, async, true);
    }

    public TorrentHandle addTorrentSupport(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile, boolean async, boolean useResumeSavePath) {
        String savePath = null;
        if (saveDir != null) {
            savePath = saveDir.getAbsolutePath();
        } else if (resumeFile == null) {
            throw new IllegalArgumentException("Both saveDir and resumeFile can't be null at the same time");
        }
        add_torrent_params p = add_torrent_params.create_instance();
        p.set_ti(ti.swig());
        if (savePath != null) {
            p.setSave_path(savePath);
        }
        if (priorities != null) {
            byte_vector v = new byte_vector();
            for (int i = 0; i < priorities.length; ++i) {
                v.push_back((byte)priorities[i].swig());
            }
            p.set_file_priorities(v);
        }
        p.setStorage_mode(storage_mode_t.storage_mode_sparse);
        long flags = p.get_flags();
        flags &= (long)(~add_torrent_params.flags_t.flag_auto_managed.swigValue());
        if (resumeFile != null) {
            try {
                byte[] data = Files.bytes(resumeFile);
                p.set_resume_data(Vectors.bytes2byte_vector(data));
                if (useResumeSavePath) {
                    flags |= (long)add_torrent_params.flags_t.flag_use_resume_save_path.swigValue();
                }
            }
            catch (Throwable e) {
                LOG.warn("Unable to set resume data", e);
            }
        }
        p.set_flags(flags);
        if (async) {
            this.s.async_add_torrent(p);
            return null;
        }
        error_code ec = new error_code();
        torrent_handle th = this.s.add_torrent(p, ec);
        return new TorrentHandle(th);
    }

    private void alertsLoop() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                alert_ptr_vector vector = new alert_ptr_vector();
                while (Session.this.running) {
                    long now;
                    alert ptr = Session.this.s.wait_for_alert_ms(500L);
                    if (ptr != null) {
                        Session.this.s.pop_alerts(vector);
                        long size = vector.size();
                        int i = 0;
                        while ((long)i < size) {
                            alert swigAlert = vector.get(i);
                            int type = swigAlert.type();
                            Alert alert2 = null;
                            if (type == AlertType.SESSION_STATS.swig()) {
                                alert2 = Alerts.cast(swigAlert);
                                Session.this.updateSessionStat((SessionStatsAlert)alert2);
                            }
                            if (type == AlertType.METADATA_RECEIVED.swig()) {
                                alert2 = Alerts.cast(swigAlert);
                                Session.this.saveMagnetData((MetadataReceivedAlert)alert2);
                            }
                            if (Session.this.listeners.indexOfKey(type) >= 0) {
                                if (alert2 == null) {
                                    alert2 = Alerts.cast(swigAlert);
                                }
                                Session.this.fireAlert(alert2, type);
                            }
                            if (type != AlertType.SESSION_STATS.swig() && Session.this.listeners.indexOfKey(-1) >= 0) {
                                if (alert2 == null) {
                                    alert2 = Alerts.cast(swigAlert);
                                }
                                Session.this.fireAlert(alert2, -1);
                            }
                            ++i;
                        }
                        vector.clear();
                    }
                    if ((now = System.currentTimeMillis()) - Session.this.lastStatsRequestTime < 1000L) continue;
                    Session.this.lastStatsRequestTime = now;
                    Session.this.postSessionStats();
                }
            }
        };
        Thread t = new Thread(r, "Session-alertsLoop");
        t.setDaemon(true);
        t.start();
    }

    private void modifyListeners(boolean adding, AlertListener listener) {
        if (listener != null) {
            int[] types = listener.types();
            if (types == null) {
                this.modifyListeners(adding, -1, listener);
            } else {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == -1) {
                        throw new IllegalArgumentException("Type can't be the key of all (-1)");
                    }
                    this.modifyListeners(adding, types[i], listener);
                }
            }
        }
    }

    private void modifyListeners(boolean adding, int type, AlertListener listener) {
        ArrayList<AlertListener> l = this.listeners.get(type);
        if (l == null) {
            l = new ArrayList();
            this.listeners.append(type, l);
        }
        if (adding) {
            l.add(listener);
        } else {
            l.remove(listener);
        }
        this.listenerSnapshots.append(type, l.toArray(new AlertListener[0]));
    }

    private static List<Pair<String, Integer>> defaultRouters() {
        LinkedList<Pair<String, Integer>> list = new LinkedList<Pair<String, Integer>>();
        list.add(new Pair<String, Integer>("router.bittorrent.com", 6881));
        list.add(new Pair<String, Integer>("dht.transmissionbt.com", 6881));
        return list;
    }

    private void updateSessionStat(SessionStatsAlert alert2) {
        long now = System.currentTimeMillis();
        long tickIntervalMs = now - this.lastStatSecondTick;
        this.lastStatSecondTick = now;
        long received = alert2.value(counters.stats_counter_t.recv_bytes.swigValue());
        long payload = alert2.value(counters.stats_counter_t.recv_payload_bytes.swigValue());
        long protocol = received - payload;
        long ip = alert2.value(counters.stats_counter_t.recv_ip_overhead_bytes.swigValue());
        this.stat.received(payload -= this.stat.downloadPayload(), protocol -= this.stat.downloadProtocol(), ip -= this.stat.downloadIPProtocol());
        long sent = alert2.value(counters.stats_counter_t.sent_bytes.swigValue());
        payload = alert2.value(counters.stats_counter_t.sent_payload_bytes.swigValue());
        protocol = sent - payload;
        ip = alert2.value(counters.stats_counter_t.sent_ip_overhead_bytes.swigValue());
        this.stat.sent(payload -= this.stat.uploadPayload(), protocol -= this.stat.uploadProtocol(), ip -= this.stat.uploadIPProtocol());
        this.stat.secondTick(tickIntervalMs);
        this.stats.dhtNodes(alert2.value(counters.stats_gauge_t.dht_nodes.swigValue()));
    }

    private void saveMagnetData(MetadataReceivedAlert alert2) {
        try {
            torrent_handle th = alert2.handle().swig();
            TorrentInfo ti = new TorrentInfo(th.get_torrent_copy());
            String sha1 = ti.infoHash().toHex();
            byte[] data = ti.bencode();
            MAGNET_CACHE.put(sha1, data);
        }
        catch (Throwable e) {
            LOG.error("Error in saving magnet in internal cache", e);
        }
    }

    private static session createSession(SettingsPack settings, boolean logging) {
        settings_pack sp = settings.swig();
        int alert_mask = alert.category_t.all_categories.swigValue();
        if (!logging) {
            int log_mask = alert.category_t.session_log_notification.swigValue() | alert.category_t.torrent_log_notification.swigValue() | alert.category_t.peer_log_notification.swigValue() | alert.category_t.dht_log_notification.swigValue() | alert.category_t.port_mapping_log_notification.swigValue();
            alert_mask &= ~log_mask;
        }
        sp.set_int(settings_pack.int_types.alert_mask.swigValue(), alert_mask);
        return new session(sp);
    }

    private static SettingsPack createSettings(String interfaces, int retries) {
        settings_pack sp = new settings_pack();
        sp.set_str(settings_pack.string_types.listen_interfaces.swigValue(), interfaces);
        sp.set_int(settings_pack.int_types.max_retry_port_bind.swigValue(), retries);
        return new SettingsPack(sp);
    }
}

