/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AddTorrentParams;
import com.frostwire.jlibtorrent.ErrorCode;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.plugins.DhtStorage;
import com.frostwire.jlibtorrent.plugins.SwigDhtStorage;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.session_handle;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_handle_vector;
import java.util.ArrayList;

public class SessionHandle {
    private static final Logger LOG = Logger.getLogger(SessionHandle.class);
    protected final session_handle s;
    private SwigDhtStorage dhtStorage;

    public SessionHandle(session_handle s) {
        this.s = s;
    }

    public session_handle swig() {
        return this.s;
    }

    public boolean isValid() {
        return this.s.is_valid();
    }

    public byte[] saveState(long flags) {
        entry e = new entry();
        this.s.save_state(e, flags);
        return Vectors.byte_vector2bytes(e.bencode());
    }

    public byte[] saveState() {
        entry e = new entry();
        this.s.save_state(e);
        return Vectors.byte_vector2bytes(e.bencode());
    }

    public void loadState(byte[] data, long flags) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            this.s.load_state(n, flags);
            buffer.clear();
        } else {
            LOG.error("failed to decode bencoded data: " + ec.message());
        }
    }

    public void loadState(byte[] data) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            this.s.load_state(n);
            buffer.clear();
        } else {
            LOG.error("failed to decode bencoded data: " + ec.message());
        }
    }

    public TorrentHandle findTorrent(Sha1Hash infoHash) {
        torrent_handle th = this.s.find_torrent(infoHash.swig());
        return th != null && th.is_valid() ? new TorrentHandle(th) : null;
    }

    public ArrayList<TorrentHandle> getTorrents() {
        torrent_handle_vector v = this.s.get_torrents();
        int size = (int)v.size();
        ArrayList<TorrentHandle> l = new ArrayList<TorrentHandle>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new TorrentHandle(v.get(i)));
        }
        return l;
    }

    public TorrentHandle addTorrent(AddTorrentParams params, ErrorCode ec) {
        return new TorrentHandle(this.s.add_torrent(params.swig(), ec.swig()));
    }

    public void asyncAddTorrent(AddTorrentParams params) {
        this.s.async_add_torrent(params.swig());
    }

    public void setDhtStorage(DhtStorage storage) {
        this.dhtStorage = new SwigDhtStorage(storage);
        this.s.set_swig_dht_storage(this.dhtStorage);
    }

    public void applySettings(SettingsPack sp) {
        this.s.apply_settings(sp.swig());
    }

    public static enum ProtocolType {
        UDP(session_handle.protocol_type.udp),
        TCP(session_handle.protocol_type.tcp);

        private final session_handle.protocol_type swigObj;

        private ProtocolType(session_handle.protocol_type swigObj) {
            this.swigObj = swigObj;
        }

        public session_handle.protocol_type swig() {
            return this.swigObj;
        }
    }

    public static enum Options {
        DELETE_FILES(session_handle.options_t.delete_files.swigValue()),
        DELETE_PARTFILE(session_handle.options_t.delete_partfile.swigValue());

        private final int swigValue;

        private Options(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }
    }
}

