/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.AlertMulticaster;
import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.StatsMetric;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.Alerts;
import com.frostwire.jlibtorrent.alerts.ExternalIpAlert;
import com.frostwire.jlibtorrent.alerts.ListenSucceededAlert;
import com.frostwire.jlibtorrent.alerts.MetadataReceivedAlert;
import com.frostwire.jlibtorrent.alerts.SessionStatsAlert;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.alert;
import com.frostwire.jlibtorrent.swig.alert_ptr_vector;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.int_vector;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.metadata_received_alert;
import com.frostwire.jlibtorrent.swig.session;
import com.frostwire.jlibtorrent.swig.settings_pack;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.storage_mode_t;
import com.frostwire.jlibtorrent.swig.torrent_alert;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_handle_vector;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.torrent_status;
import java.io.File;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SessionManager {
    private static final Logger LOG = Logger.getLogger(SessionManager.class);
    private static final long REQUEST_STATS_RESOLUTION_MILLIS = 1000L;
    private static final long ALERTS_LOOP_WAIT_MILLIS = 500L;
    private static final int[] METADATA_ALERT_TYPES = new int[]{AlertType.METADATA_RECEIVED.swig(), AlertType.METADATA_FAILED.swig()};
    private final boolean logging;
    private final AlertListener[] listeners;
    private final ReentrantLock sync;
    private final ReentrantLock syncMagnet;
    private session session;
    private final SessionStats stats;
    private long lastStatsRequestTime;
    private boolean firewalled;
    private final List<TcpEndpoint> listenEndpoints;
    private Address externalAddress;

    public SessionManager(boolean logging) {
        this.logging = logging;
        this.listeners = new AlertListener[libtorrent.num_alert_types + 1];
        this.sync = new ReentrantLock();
        this.syncMagnet = new ReentrantLock();
        this.stats = new SessionStats();
        this.listenEndpoints = new LinkedList<TcpEndpoint>();
        this.resetState();
    }

    public SessionManager() {
        this(false);
    }

    public session swig() {
        return this.session;
    }

    public void addListener(AlertListener listener) {
        this.modifyListeners(true, listener);
    }

    public void removeListener(AlertListener listener) {
        this.modifyListeners(false, listener);
    }

    public void start(SettingsPack sp) {
        if (this.session != null) {
            return;
        }
        this.sync.lock();
        try {
            if (this.session != null) {
                return;
            }
            this.onBeforeStart();
            this.resetState();
            sp.setInteger(settings_pack.int_types.alert_mask.swigValue(), SessionManager.alertMask(this.logging));
            this.session = new session(sp.swig());
            this.alertsLoop();
            this.onAfterStart();
        }
        finally {
            this.sync.unlock();
        }
    }

    public void start() {
        settings_pack sp = new settings_pack();
        sp.set_str(settings_pack.string_types.dht_bootstrap_nodes.swigValue(), SessionManager.dhtBootstrapNodes());
        this.start(new SettingsPack(sp));
    }

    public void stop() {
        if (this.session == null) {
            return;
        }
        this.sync.lock();
        try {
            if (this.session == null) {
                return;
            }
            this.onBeforeStop();
            session s = this.session;
            this.session = null;
            this.resetState();
            s.abort().delete();
            this.onAfterStop();
        }
        finally {
            this.sync.unlock();
        }
    }

    public void restart() {
        this.sync.lock();
        try {
            this.stop();
            Thread.sleep(1000L);
            this.start();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.sync.unlock();
        }
    }

    public boolean isRunning() {
        return this.session != null;
    }

    public void pause() {
        if (this.session != null && !this.session.is_paused()) {
            this.session.pause();
        }
    }

    public void resume() {
        if (this.session != null) {
            this.session.resume();
        }
    }

    public boolean isPaused() {
        return this.session != null ? this.session.is_paused() : false;
    }

    public SessionStats stats() {
        return this.stats;
    }

    public long downloadRate() {
        return this.stats.downloadRate();
    }

    public long uploadRate() {
        return this.stats.uploadRate();
    }

    public long totalDownload() {
        return this.stats.totalDownload();
    }

    public long totalUpload() {
        return this.stats.totalUpload();
    }

    public long dhtNodes() {
        return this.stats.dhtNodes();
    }

    public boolean isFirewalled() {
        return this.firewalled;
    }

    public Address externalAddress() {
        return this.externalAddress;
    }

    public List<TcpEndpoint> listenEndpoints() {
        return new LinkedList<TcpEndpoint>(this.listenEndpoints);
    }

    public SettingsPack settings() {
        return this.session != null ? new SettingsPack(this.session.get_settings()) : null;
    }

    public void applySettings(SettingsPack sp) {
        if (this.session != null) {
            if (sp == null) {
                throw new IllegalArgumentException("settings pack can't be null");
            }
            this.session.apply_settings(sp.swig());
            this.onApplySettings(sp);
        }
    }

    public int downloadRateLimit() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().downloadRateLimit();
    }

    public void downloadRateLimit(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.downloadRateLimit(limit);
        this.applySettings(sp);
    }

    public int uploadRateLimit() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().uploadRateLimit();
    }

    public void uploadRateLimit(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.uploadRateLimit(limit);
        this.applySettings(sp);
    }

    public int maxActiveDownloads() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().activeDownloads();
    }

    public void maxActiveDownloads(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.activeDownloads(limit);
        this.applySettings(sp);
    }

    public int maxActiveSeeds() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().activeSeeds();
    }

    public void maxActiveSeeds(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.activeSeeds(limit);
        this.applySettings(sp);
    }

    public int maxConnections() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().connectionsLimit();
    }

    public void maxConnections(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.connectionsLimit(limit);
        this.applySettings(sp);
    }

    public int maxPeers() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().maxPeerlistSize();
    }

    public void maxPeers(int limit) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.maxPeerlistSize(limit);
        this.applySettings(sp);
    }

    public String listenInterfaces() {
        if (this.session == null) {
            return null;
        }
        return this.settings().getString(settings_pack.string_types.listen_interfaces.swigValue());
    }

    public void listenInterfaces(String value) {
        if (this.session == null) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.setString(settings_pack.string_types.listen_interfaces.swigValue(), value);
        this.applySettings(sp);
    }

    public void postSessionStats() {
        if (this.session != null) {
            this.session.post_session_stats();
        }
    }

    public void postDHTStats() {
        if (this.session != null) {
            this.session.post_dht_stats();
        }
    }

    public boolean isDhtRunning() {
        return this.session != null ? this.session.is_dht_running() : false;
    }

    public void startDht() {
        this.toggleDht(true);
    }

    public void stopDht() {
        this.toggleDht(false);
    }

    private void toggleDht(boolean on) {
        if (this.session == null || this.isDhtRunning() == on) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.enableDht(on);
        this.applySettings(sp);
    }

    public TorrentHandle find(Sha1Hash sha1) {
        if (this.session == null) {
            return null;
        }
        torrent_handle th = this.session.find_torrent(sha1.swig());
        return th != null && th.is_valid() ? new TorrentHandle(th) : null;
    }

    public void download(TorrentInfo ti, File saveDir) {
        this.download(ti, saveDir, null, null, null);
    }

    public void download(TorrentInfo ti, File saveDir, File resumeFile, Priority[] priorities, String magnetUrlParams) {
        String savePath = null;
        if (saveDir != null) {
            savePath = saveDir.getAbsolutePath();
        } else if (resumeFile == null) {
            throw new IllegalArgumentException("Both saveDir and resumeFile can't be null at the same time");
        }
        add_torrent_params p = add_torrent_params.create_instance();
        if (magnetUrlParams != null && !magnetUrlParams.isEmpty()) {
            p.setUrl(magnetUrlParams);
        }
        p.set_ti(ti.swig());
        if (savePath != null) {
            p.setSave_path(savePath);
        }
        if (priorities != null) {
            byte_vector v = new byte_vector();
            for (int i = 0; i < priorities.length; ++i) {
                v.push_back((byte)priorities[i].swig());
            }
            p.set_file_priorities(v);
        }
        p.setStorage_mode(storage_mode_t.storage_mode_sparse);
        long flags = p.get_flags();
        flags &= (long)(~add_torrent_params.flags_t.flag_auto_managed.swigValue());
        if (resumeFile != null) {
            try {
                byte[] data = Files.bytes(resumeFile);
                p.set_resume_data(Vectors.bytes2byte_vector(data));
                flags |= (long)add_torrent_params.flags_t.flag_use_resume_save_path.swigValue();
            }
            catch (Throwable e) {
                LOG.warn("Unable to set resume data", e);
            }
        }
        p.set_flags(flags);
        this.session.async_add_torrent(p);
    }

    public void remove(TorrentHandle th, SessionHandle.Options options) {
        if (this.session != null && th.isValid()) {
            this.session.remove_torrent(th.swig(), options.swig());
        }
    }

    public void remove(TorrentHandle th) {
        if (this.session != null && th.isValid()) {
            this.session.remove_torrent(th.swig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchMagnet(String uri, int timeout, final int maxSize) {
        if (this.session == null) {
            return null;
        }
        add_torrent_params p = add_torrent_params.create_instance_disabled_storage();
        error_code ec = new error_code();
        libtorrent.parse_magnet_uri(uri, p, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
        final sha1_hash info_hash = p.getInfo_hash();
        final byte[][] data = new byte[1][];
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener listener = new AlertListener(){

            @Override
            public int[] types() {
                return METADATA_ALERT_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                torrent_handle th = ((torrent_alert)((TorrentAlert)alert2).swig()).getHandle();
                if (th == null || !th.is_valid() || !th.info_hash().op_eq(info_hash)) {
                    return;
                }
                AlertType type = alert2.type();
                if (type.equals((Object)AlertType.METADATA_RECEIVED)) {
                    int size;
                    MetadataReceivedAlert a = (MetadataReceivedAlert)alert2;
                    byte[] arr = SessionManager.this.torrentData(a);
                    int n = size = arr != null ? arr.length : -1;
                    if (0 < size && size <= maxSize) {
                        data[0] = arr;
                    }
                }
                signal.countDown();
            }
        };
        this.addListener(listener);
        boolean add = false;
        torrent_handle th = null;
        try {
            this.syncMagnet.lock();
            try {
                th = this.session.find_torrent(info_hash);
                add = th == null || !th.is_valid();
                if (add) {
                    p.setName("fetch_magnet" + uri);
                    p.setSave_path("fetch_magnet" + uri);
                    long flags = p.get_flags();
                    p.set_flags(flags &= (long)(~add_torrent_params.flags_t.flag_auto_managed.swigValue()));
                    ec.clear();
                    th = this.session.add_torrent(p, ec);
                    th.resume();
                }
            }
            finally {
                this.syncMagnet.unlock();
            }
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error fetching magnet", e);
        }
        finally {
            this.removeListener(listener);
            if (this.session != null && add && th != null && th.is_valid()) {
                this.session.remove_torrent(th);
            }
        }
        return data[0];
    }

    public byte[] fetchMagnet(String uri, int timeout) {
        return this.fetchMagnet(uri, timeout, 0x200000);
    }

    public void moveStorage(File dir) {
        if (this.session == null) {
            return;
        }
        try {
            torrent_handle_vector v = this.session.get_torrents();
            int size = (int)v.size();
            String path = dir.getAbsolutePath();
            for (int i = 0; i < size; ++i) {
                boolean incomplete;
                torrent_handle th = v.get(i);
                torrent_status ts = th.status();
                boolean bl = incomplete = !ts.getIs_seeding() && !ts.getIs_finished();
                if (!th.is_valid() || !incomplete) continue;
                th.move_storage(path);
            }
        }
        catch (Throwable e) {
            LOG.error("Error changing save path for session", e);
        }
    }

    public byte[] saveState() {
        return new SessionHandle(this.session).saveState();
    }

    public void loadState(byte[] data) {
        new SessionHandle(this.session).loadState(data);
    }

    public String magnetPeers() {
        if (this.session == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (TcpEndpoint endp : this.listenEndpoints) {
            try {
                Address address2 = endp.address();
                if (address2.isLoopback() || address2.isMulticast()) continue;
                if (address2.isUnspecified()) {
                    try {
                        SessionManager.addAllInterfaces(address2.isV6(), endp.port(), sb);
                    }
                    catch (Throwable e) {
                        LOG.error("Error adding all listen interfaces", e);
                    }
                } else {
                    SessionManager.addMagnetPeer(endp.address(), endp.port(), sb);
                }
                if (this.externalAddress == null) continue;
                SessionManager.addMagnetPeer(this.externalAddress, endp.port(), sb);
            }
            catch (Throwable e) {
                LOG.error("Error processing listen endpoint", e);
            }
        }
        return sb.toString();
    }

    protected void onBeforeStart() {
    }

    protected void onAfterStart() {
    }

    protected void onBeforeStop() {
    }

    protected void onAfterStop() {
    }

    protected void onApplySettings(SettingsPack sp) {
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    private void resetState() {
        this.stats.clear();
        this.firewalled = true;
        this.listenEndpoints.clear();
        this.externalAddress = null;
    }

    private void modifyListeners(boolean add, AlertListener listener) {
        if (listener == null) {
            return;
        }
        int[] types = listener.types();
        if (types == null) {
            this.modifyListeners(add, libtorrent.num_alert_types, listener);
        } else {
            for (int i = 0; i < types.length; ++i) {
                this.modifyListeners(add, types[i], listener);
            }
        }
    }

    private synchronized void modifyListeners(boolean add, int type, AlertListener listener) {
        this.listeners[type] = add ? AlertMulticaster.add(this.listeners[type], listener) : AlertMulticaster.remove(this.listeners[type], listener);
    }

    private void fireAlert(Alert<?> a, int type) {
        AlertListener listener = this.listeners[type];
        if (listener != null) {
            try {
                listener.alert(a);
            }
            catch (Throwable e) {
                LOG.warn("Error calling alert listener", e);
            }
        }
    }

    private void onListenSucceeded(ListenSucceededAlert alert2) {
        try {
            if (alert2.socketType() == ListenSucceededAlert.SocketType.TCP) {
                String address2 = alert2.address().toString();
                int port = alert2.port();
                this.listenEndpoints.add(new TcpEndpoint(address2, port));
            }
        }
        catch (Throwable e) {
            LOG.error("Error adding listen endpoint to internal list", e);
        }
    }

    private void onExternalIpAlert(ExternalIpAlert alert2) {
        try {
            String address2 = alert2.externalAddress().toString();
            this.externalAddress = new Address(address2);
        }
        catch (Throwable e) {
            LOG.error("Error saving reported external ip", e);
        }
    }

    private static int alertMask(boolean logging) {
        int mask = alert.category_t.all_categories.swigValue();
        if (!logging) {
            int log_mask = alert.category_t.session_log_notification.swigValue() | alert.category_t.torrent_log_notification.swigValue() | alert.category_t.peer_log_notification.swigValue() | alert.category_t.dht_log_notification.swigValue() | alert.category_t.port_mapping_log_notification.swigValue() | alert.category_t.picker_log_notification.swigValue();
            mask &= ~log_mask;
        }
        return mask;
    }

    private static String dhtBootstrapNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append("dht.libtorrent.org:25401").append(",");
        sb.append("router.bittorrent.com:6881").append(",");
        sb.append("dht.transmissionbt.com:6881").append(",");
        sb.append("outer.silotis.us:6881");
        return sb.toString();
    }

    private static void addAllInterfaces(boolean v6, int port, StringBuilder sb) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface iface = networkInterfaces.nextElement();
            if (iface.isLoopback()) continue;
            List<InterfaceAddress> interfaceAddresses = iface.getInterfaceAddresses();
            for (InterfaceAddress ifaceAddress : interfaceAddresses) {
                InetAddress inetAddress = ifaceAddress.getAddress();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress instanceof Inet6Address != v6) continue;
                String hostAddress = ifaceAddress.getAddress().getHostAddress();
                if (v6) {
                    if (hostAddress.contains("%")) {
                        hostAddress = hostAddress.substring(0, hostAddress.indexOf("%"));
                    }
                    hostAddress = "[" + hostAddress + "]";
                }
                sb.append("&x.pe=" + hostAddress + ":" + port);
            }
        }
    }

    private static void addMagnetPeer(Address address2, int port, StringBuilder sb) {
        String hostAddress = address2.toString();
        if (hostAddress.contains("invalid")) {
            return;
        }
        if (address2.isV6()) {
            hostAddress = "[" + hostAddress + "]";
        }
        sb.append("&x.pe=" + hostAddress + ":" + port);
    }

    private void alertsLoop() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                alert_ptr_vector v = new alert_ptr_vector();
                while (SessionManager.this.session != null) {
                    long now;
                    alert ptr = SessionManager.this.session.wait_for_alert_ms(500L);
                    if (SessionManager.this.session == null) {
                        return;
                    }
                    if (ptr != null) {
                        SessionManager.this.session.pop_alerts(v);
                        long size = v.size();
                        int i = 0;
                        while ((long)i < size) {
                            alert a = v.get(i);
                            int type = a.type();
                            Alert alert2 = null;
                            switch (AlertType.fromSwig(type)) {
                                case SESSION_STATS: {
                                    alert2 = Alerts.cast(a);
                                    SessionManager.this.stats.update((SessionStatsAlert)alert2);
                                    break;
                                }
                                case PORTMAP: {
                                    SessionManager.this.firewalled = false;
                                    break;
                                }
                                case PORTMAP_ERROR: {
                                    SessionManager.this.firewalled = true;
                                    break;
                                }
                                case LISTEN_SUCCEEDED: {
                                    alert2 = Alerts.cast(a);
                                    SessionManager.this.onListenSucceeded((ListenSucceededAlert)alert2);
                                    break;
                                }
                                case EXTERNAL_IP: {
                                    alert2 = Alerts.cast(a);
                                    SessionManager.this.onExternalIpAlert((ExternalIpAlert)alert2);
                                }
                            }
                            if (SessionManager.this.listeners[type] != null) {
                                if (alert2 == null) {
                                    alert2 = Alerts.cast(a);
                                }
                                SessionManager.this.fireAlert(alert2, type);
                            }
                            if (type != AlertType.SESSION_STATS.swig() && SessionManager.this.listeners[libtorrent.num_alert_types] != null) {
                                if (alert2 == null) {
                                    alert2 = Alerts.cast(a);
                                }
                                SessionManager.this.fireAlert(alert2, libtorrent.num_alert_types);
                            }
                            ++i;
                        }
                        v.clear();
                    }
                    if ((now = System.currentTimeMillis()) - SessionManager.this.lastStatsRequestTime < 1000L) continue;
                    SessionManager.this.lastStatsRequestTime = now;
                    SessionManager.this.postSessionStats();
                }
            }
        };
        Thread t = new Thread(r, "SessionManager-alertsLoop");
        t.setDaemon(true);
        t.start();
    }

    static int_vector array2int_vector(Priority[] arr) {
        int_vector v = new int_vector();
        for (int i = 0; i < arr.length; ++i) {
            Priority p = arr[i];
            v.push_back(p != Priority.UNKNOWN ? p.swig() : Priority.IGNORE.swig());
        }
        return v;
    }

    public byte[] torrentData(MetadataReceivedAlert alert2) {
        try {
            torrent_handle th = ((metadata_received_alert)alert2.swig()).getHandle();
            if (th == null || !th.is_valid()) {
                return null;
            }
            torrent_info ti = th.get_torrent_copy();
            if (ti == null || !ti.is_valid()) {
                return null;
            }
            create_torrent ct = new create_torrent(ti);
            entry e = ct.generate();
            return Vectors.byte_vector2bytes(e.bencode());
        }
        catch (Throwable e) {
            LOG.error("Error building torrent data from metadata", e);
            return null;
        }
    }

    public static final class SessionStats {
        private static final int UPLOAD_PAYLOAD = 0;
        private static final int UPLOAD_PROTOCOL = 1;
        private static final int UPLOAD_IP_PROTOCOL = 2;
        private static final int DOWNLOAD_PAYLOAD = 3;
        private static final int DOWNLOAD_PROTOCOL = 4;
        private static final int DOWNLOAD_IP_PROTOCOL = 5;
        private static final int NUM_AVERAGES = 6;
        private final Average[] stat = new Average[6];
        private long lastTickTime;
        private long dhtNodes;

        SessionStats() {
            for (int i = 0; i < this.stat.length; ++i) {
                this.stat[i] = new Average();
            }
        }

        public long totalDownload() {
            return this.stat[3].total() + this.stat[4].total() + this.stat[5].total();
        }

        public long totalUpload() {
            return this.stat[0].total() + this.stat[1].total() + this.stat[2].total();
        }

        public long downloadRate() {
            return this.stat[3].rate() + this.stat[4].rate() + this.stat[5].rate();
        }

        public long uploadRate() {
            return this.stat[0].rate() + this.stat[1].rate() + this.stat[2].rate();
        }

        public long dhtNodes() {
            return this.dhtNodes;
        }

        void update(SessionStatsAlert alert2) {
            long now = System.currentTimeMillis();
            long tickIntervalMs = now - this.lastTickTime;
            this.lastTickTime = now;
            long received = alert2.value(StatsMetric.NET_RECV_BYTES_COUNTER_INDEX);
            long payload = alert2.value(StatsMetric.NET_RECV_PAYLOAD_BYTES_COUNTER_INDEX);
            long protocol = received - payload;
            long ip = alert2.value(StatsMetric.NET_RECV_IP_OVERHEAD_BYTES_COUNTER_INDEX);
            this.stat[3].add(payload -= this.stat[3].total());
            this.stat[4].add(protocol -= this.stat[4].total());
            this.stat[5].add(ip -= this.stat[5].total());
            long sent = alert2.value(StatsMetric.NET_SENT_BYTES_COUNTER_INDEX);
            payload = alert2.value(StatsMetric.NET_SENT_PAYLOAD_BYTES_COUNTER_INDEX);
            protocol = sent - payload;
            ip = alert2.value(StatsMetric.NET_SENT_IP_OVERHEAD_BYTES_COUNTER_INDEX);
            this.stat[0].add(payload -= this.stat[0].total());
            this.stat[1].add(protocol -= this.stat[1].total());
            this.stat[2].add(ip -= this.stat[2].total());
            this.tick(tickIntervalMs);
            this.dhtNodes = alert2.value(StatsMetric.DHT_NODES_GAUGE_INDEX);
        }

        void clear() {
            for (int i = 0; i < 6; ++i) {
                this.stat[i].clear();
            }
            this.dhtNodes = 0L;
        }

        private void tick(long tickIntervalMs) {
            for (int i = 0; i < 6; ++i) {
                this.stat[i].tick(tickIntervalMs);
            }
        }

        private static final class Average {
            private long totalCounter;
            private long counter;
            private long averageSec5;

            public void add(long count) {
                this.counter += count;
                this.totalCounter += count;
            }

            public void tick(long tickIntervalMs) {
                if (tickIntervalMs >= 1L) {
                    long sample = this.counter * 1000L / tickIntervalMs;
                    this.averageSec5 = this.averageSec5 * 4L / 5L + sample / 5L;
                    this.counter = 0L;
                }
            }

            public long rate() {
                return this.averageSec5;
            }

            public long total() {
                return this.totalCounter;
            }

            public void clear() {
                this.counter = 0L;
                this.averageSec5 = 0L;
                this.totalCounter = 0L;
            }
        }
    }
}

