/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.PartialPieceInfo;
import com.frostwire.jlibtorrent.PeerInfo;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.announce_entry_vector;
import com.frostwire.jlibtorrent.swig.int64_vector;
import com.frostwire.jlibtorrent.swig.int_vector;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.partial_piece_info_vector;
import com.frostwire.jlibtorrent.swig.peer_info_vector;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.torrent_status;
import java.util.ArrayList;
import java.util.List;

public final class TorrentHandle {
    private static final long REQUEST_STATUS_RESOLUTION_MILLIS = 500L;
    private final torrent_handle th;
    private long lastStatusRequestTime;
    private TorrentStatus lastStatus;

    public TorrentHandle(torrent_handle th) {
        this.th = th;
    }

    public torrent_handle swig() {
        return this.th;
    }

    public void addPiece(int piece, byte[] data, int flags) {
        this.th.add_piece_bytes(piece, Vectors.bytes2byte_vector(data), flags);
    }

    public void addPiece(int piece, byte[] data) {
        this.th.add_piece_bytes(piece, Vectors.bytes2byte_vector(data));
    }

    public void readPiece(int piece) {
        this.th.read_piece(piece);
    }

    public boolean havePiece(int piece) {
        return this.th.have_piece(piece);
    }

    public ArrayList<PeerInfo> peerInfo() {
        if (!this.th.is_valid()) {
            return new ArrayList<PeerInfo>();
        }
        peer_info_vector v = new peer_info_vector();
        this.th.get_peer_info(v);
        int size = (int)v.size();
        ArrayList<PeerInfo> l = new ArrayList<PeerInfo>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new PeerInfo(v.get(i)));
        }
        return l;
    }

    public TorrentInfo torrentFile() {
        torrent_info ti = this.th.get_torrent_copy();
        return ti != null ? new TorrentInfo(ti) : null;
    }

    public TorrentStatus status(boolean force) {
        long now = System.currentTimeMillis();
        if (force || now - this.lastStatusRequestTime >= 500L) {
            this.lastStatusRequestTime = now;
            this.lastStatus = new TorrentStatus(this.th.status());
        }
        return this.lastStatus;
    }

    public TorrentStatus status() {
        return this.status(false);
    }

    public ArrayList<PartialPieceInfo> getDownloadQueue() {
        partial_piece_info_vector v = new partial_piece_info_vector();
        this.th.get_download_queue(v);
        int size = (int)v.size();
        ArrayList<PartialPieceInfo> l = new ArrayList<PartialPieceInfo>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new PartialPieceInfo(v.get(i)));
        }
        return l;
    }

    public Sha1Hash infoHash() {
        return new Sha1Hash(this.th.info_hash());
    }

    public void pause() {
        this.th.pause();
    }

    public void resume() {
        this.th.resume();
    }

    public void stopWhenReady(boolean value) {
        this.th.stop_when_ready(value);
    }

    public void setUploadMode(boolean value) {
        this.th.set_upload_mode(value);
    }

    public void setShareMode(boolean value) {
        this.th.set_share_mode(value);
    }

    public void flushCache() {
        this.th.flush_cache();
    }

    public boolean needSaveResumeData() {
        return this.th.need_save_resume_data();
    }

    public void setAutoManaged(boolean value) {
        this.th.auto_managed(value);
    }

    public int getQueuePosition() {
        return this.th.queue_position();
    }

    public void queuePositionUp() {
        this.th.queue_position_up();
    }

    public void queuePositionDown() {
        this.th.queue_position_down();
    }

    public void queuePositionTop() {
        this.th.queue_position_top();
    }

    public void queuePositionBottom() {
        this.th.queue_position_bottom();
    }

    public void saveResumeData() {
        this.th.save_resume_data(torrent_handle.save_resume_flags_t.save_info_dict.swigValue());
    }

    public boolean isValid() {
        return this.th.is_valid();
    }

    public String makeMagnetUri() {
        return this.th.is_valid() ? libtorrent.make_magnet_uri(this.th) : null;
    }

    public int getUploadLimit() {
        return this.th.upload_limit();
    }

    public void setUploadLimit(int limit) {
        this.th.set_upload_limit(limit);
    }

    public int getDownloadLimit() {
        return this.th.download_limit();
    }

    public void setDownloadLimit(int limit) {
        this.th.set_download_limit(limit);
    }

    public void setSequentialDownload(boolean sequential) {
        this.th.set_sequential_download(sequential);
    }

    public void forceRecheck() {
        this.th.force_recheck();
    }

    public void forceReannounce(int seconds, int tracker_index) {
        this.th.force_reannounce(seconds, tracker_index);
    }

    public void forceReannounce(int seconds) {
        this.th.force_reannounce(seconds);
    }

    public void forceReannounce() {
        this.th.force_reannounce();
    }

    public void forceDHTAnnounce() {
        this.th.force_dht_announce();
    }

    public List<AnnounceEntry> trackers() {
        return TorrentInfo.trackers(this.th.trackers());
    }

    public void scrapeTracker() {
        this.th.scrape_tracker();
    }

    public void replaceTrackers(List<AnnounceEntry> trackers) {
        announce_entry_vector v = new announce_entry_vector();
        for (AnnounceEntry t : trackers) {
            v.push_back(t.swig());
        }
        this.th.replace_trackers(v);
    }

    public void addTracker(AnnounceEntry tracker) {
        this.th.add_tracker(tracker.swig());
    }

    public void addUrlSeed(String url) {
        this.th.add_url_seed(url);
    }

    public void removeUrlSeed(String url) {
        this.th.remove_url_seed(url);
    }

    public void addHttpSeed(String url) {
        this.th.add_url_seed(url);
    }

    public void removeHttpSeed(String url) {
        this.th.remove_http_seed(url);
    }

    public int[] getPieceAvailability() {
        int_vector v = new int_vector();
        this.th.piece_availability(v);
        return Vectors.int_vector2ints(v);
    }

    public void piecePriority(int index, Priority priority) {
        this.th.piece_priority(index, priority.swig());
    }

    public Priority piecePriority(int index) {
        return Priority.fromSwig(this.th.piece_priority(index));
    }

    public void prioritizePieces(Priority[] priorities) {
        this.th.prioritize_pieces(Priority.array2int_vector(priorities));
    }

    public Priority[] getPiecePriorities() {
        int_vector v = this.th.piece_priorities();
        int size = (int)v.size();
        Priority[] arr = new Priority[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = Priority.fromSwig(v.get(i));
        }
        return arr;
    }

    public void setFilePriority(int index, Priority priority) {
        this.th.file_priority(index, priority.swig());
    }

    public Priority getFilePriority(int index) {
        return Priority.fromSwig(this.th.file_priority(index));
    }

    public void prioritizeFiles(Priority[] priorities) {
        this.th.prioritize_files(Priority.array2int_vector(priorities));
    }

    public Priority[] filePriorities() {
        int_vector v = this.th.file_priorities();
        int size = (int)v.size();
        Priority[] arr = new Priority[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = Priority.fromSwig(v.get(i));
        }
        return arr;
    }

    public void setPieceDeadline(int index, int deadline) {
        this.th.set_piece_deadline(index, deadline);
    }

    public void setPieceDeadline(int index, int deadline, DeadlineFlags flags) {
        this.th.set_piece_deadline(index, deadline, flags.getSwig());
    }

    public void resetPieceDeadline(int index) {
        this.th.reset_piece_deadline(index);
    }

    public void clearPieceDeadlines() {
        this.th.clear_piece_deadlines();
    }

    public void setPriority(int priority) {
        if (priority < 0 || 255 < priority) {
            throw new IllegalArgumentException("The priority must be within the range [0, 255]");
        }
        this.th.set_priority(priority);
    }

    public long[] getFileProgress(FileProgressFlags flags) {
        int64_vector v = new int64_vector();
        this.th.file_progress(v, flags.getSwig());
        return Vectors.int64_vector2longs(v);
    }

    public long[] getFileProgress() {
        int64_vector v = new int64_vector();
        this.th.file_progress(v);
        return Vectors.int64_vector2longs(v);
    }

    public String getSavePath() {
        torrent_status ts = this.th.status(torrent_handle.status_flags_t.query_save_path.swigValue());
        return ts.getSave_path();
    }

    public String getName() {
        torrent_status ts = this.th.status(torrent_handle.status_flags_t.query_name.swigValue());
        return ts.getName();
    }

    public void moveStorage(String savePath, int flags) {
        this.th.move_storage(savePath, flags);
    }

    public void moveStorage(String savePath) {
        this.th.move_storage(savePath);
    }

    public void renameFile(int index, String newName) {
        this.th.rename_file(index, newName);
    }

    public static enum FileProgressFlags {
        DEFAULT(0),
        PIECE_GRANULARITY(torrent_handle.file_progress_flags_t.piece_granularity.swigValue());

        private final int swigValue;

        private FileProgressFlags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int getSwig() {
            return this.swigValue;
        }
    }

    public static enum DeadlineFlags {
        ALERT_WHEN_AVAILABLE(torrent_handle.deadline_flags.alert_when_available.swigValue());

        private final int swigValue;

        private DeadlineFlags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int getSwig() {
            return this.swigValue;
        }
    }

    public static enum StatusFlags {
        QUERY_DISTRIBUTED_COPIES(torrent_handle.status_flags_t.query_distributed_copies.swigValue()),
        QUERY_ACCURATE_DOWNLOAD_COUNTERS(torrent_handle.status_flags_t.query_accurate_download_counters.swigValue()),
        QUERY_LAST_SEEN_COMPLETE(torrent_handle.status_flags_t.query_last_seen_complete.swigValue()),
        QUERY_PIECES(torrent_handle.status_flags_t.query_pieces.swigValue()),
        QUERY_VERIFIED_PIECES(torrent_handle.status_flags_t.query_verified_pieces.swigValue()),
        QUERY_TORRENT_FILE(torrent_handle.status_flags_t.query_torrent_file.swigValue()),
        QUERY_NAME(torrent_handle.status_flags_t.query_name.swigValue()),
        QUERY_SAVE_PATH(torrent_handle.status_flags_t.query_save_path.swigValue());

        private final int swigValue;

        private StatusFlags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int getSwig() {
            return this.swigValue;
        }
    }

    public static enum Flags {
        OVERWRITE_EXISTING(torrent_handle.flags_t.overwrite_existing.swigValue()),
        UNKNOWN(-1);

        private final int swigValue;

        private Flags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }

        public static Flags fromSwig(int swigValue) {
            Flags[] enumValues;
            for (Flags ev : enumValues = (Flags[])Flags.class.getEnumConstants()) {
                if (ev.swig() != swigValue) continue;
                return ev;
            }
            return UNKNOWN;
        }
    }
}

