/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.alerts;

import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.metadata_received_alert;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_info;
import java.util.concurrent.locks.ReentrantLock;

public final class MetadataReceivedAlert
extends TorrentAlert<metadata_received_alert> {
    private static final Logger LOG = Logger.getLogger(MetadataReceivedAlert.class);
    private final ReentrantLock sync = new ReentrantLock();
    private int size;
    private byte[] data;
    private boolean invalid;

    MetadataReceivedAlert(metadata_received_alert alert2) {
        super(alert2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int metadataSize() {
        if (this.invalid) {
            return -1;
        }
        if (this.size > 0) {
            return this.size;
        }
        this.sync.lock();
        try {
            if (this.invalid) {
                int n = -1;
                return n;
            }
            if (this.size > 0) {
                int n = this.size;
                return n;
            }
            torrent_handle th = ((metadata_received_alert)this.alert).getHandle();
            if (th == null || !th.is_valid()) {
                this.invalid = true;
                int n = -1;
                return n;
            }
            torrent_info ti = th.get_torrent_copy();
            if (ti == null || !ti.is_valid()) {
                this.invalid = true;
                int n = -1;
                return n;
            }
            this.size = ti.metadata_size();
        }
        catch (Throwable e) {
            LOG.error("Error getting metadata size", e);
            this.invalid = true;
        }
        finally {
            this.sync.unlock();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] torrentData() {
        if (this.invalid) {
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        this.sync.lock();
        try {
            if (this.invalid) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.data != null) {
                byte[] byArray = this.data;
                return byArray;
            }
            torrent_handle th = ((metadata_received_alert)this.alert).getHandle();
            if (th == null || !th.is_valid()) {
                this.invalid = true;
                byte[] byArray = null;
                return byArray;
            }
            torrent_info ti = th.get_torrent_copy();
            if (ti == null || !ti.is_valid()) {
                this.invalid = true;
                byte[] byArray = null;
                return byArray;
            }
            create_torrent ct = new create_torrent(ti);
            entry e = ct.generate();
            this.size = ti.metadata_size();
            this.data = Vectors.byte_vector2bytes(e.bencode());
        }
        catch (Throwable e) {
            LOG.error("Error building torrent data from metadata", e);
            this.invalid = true;
        }
        finally {
            this.sync.unlock();
        }
        return this.data;
    }
}

