/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.profile;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.FileSystemService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import com.almasb.fxgl.profile.SaveLoadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012J\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001d0\u000f2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/almasb/fxgl/profile/SaveLoadService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "fs", "Lcom/almasb/fxgl/io/FileSystemService;", "log", "Lcom/almasb/fxgl/logging/Logger;", "saveLoadHandlers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/profile/SaveLoadHandler;", "Lkotlin/collections/ArrayList;", "addHandler", "", "saveLoadHandler", "deleteSaveFileTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/lang/Void;", "saveFileName", "", "load", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "readAndLoadTask", "readLastModifiedSaveFileTask", "Ljava/util/Optional;", "Lcom/almasb/fxgl/profile/SaveFile;", "dirName", "saveFileExt", "readSaveFilesTask", "", "readTask", "removeHandler", "save", "saveAndWriteTask", "saveFileExists", "", "writeTask", "fxgl-profiles"})
public final class SaveLoadService
extends EngineService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private FileSystemService fs;
    private final ArrayList<SaveLoadHandler> saveLoadHandlers;

    public final void addHandler(@NotNull SaveLoadHandler saveLoadHandler) {
        Intrinsics.checkNotNullParameter((Object)saveLoadHandler, (String)"saveLoadHandler");
        Collection collection = this.saveLoadHandlers;
        boolean bl = false;
        collection.add(saveLoadHandler);
    }

    public final void removeHandler(@NotNull SaveLoadHandler saveLoadHandler) {
        Intrinsics.checkNotNullParameter((Object)saveLoadHandler, (String)"saveLoadHandler");
        Collection collection = this.saveLoadHandlers;
        boolean bl = false;
        collection.remove(saveLoadHandler);
    }

    public final void save(@NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Iterable $this$forEach$iv = this.saveLoadHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SaveLoadHandler it = (SaveLoadHandler)element$iv;
            boolean bl = false;
            it.onSave(dataFile);
        }
    }

    public final void load(@NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Iterable $this$forEach$iv = this.saveLoadHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SaveLoadHandler it = (SaveLoadHandler)element$iv;
            boolean bl = false;
            it.onLoad(dataFile);
        }
    }

    public final boolean saveFileExists(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("Checking if save file exists: " + saveFileName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        return fileSystemService.exists(saveFileName);
    }

    @NotNull
    public final IOTask<Void> saveAndWriteTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        IOTask iOTask = IOTask.of((Callable)new Callable<DataFile>(this){
            final /* synthetic */ SaveLoadService this$0;

            /*
             * WARNING - void declaration
             */
            public final DataFile call() {
                void var1_1;
                DataFile dataFile = new DataFile();
                this.this$0.save(dataFile);
                return var1_1;
            }
            {
                this.this$0 = saveLoadService;
            }
        }).then((Function)new Function<DataFile, IOTask<Void>>(this, saveFileName){
            final /* synthetic */ SaveLoadService this$0;
            final /* synthetic */ String $saveFileName;

            public final IOTask<Void> apply(DataFile it) {
                DataFile dataFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataFile, (String)"it");
                return this.this$0.writeTask(this.$saveFileName, dataFile);
            }
            {
                this.this$0 = saveLoadService;
                this.$saveFileName = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"IOTask.of {\n            \u2026eTask(saveFileName, it) }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> writeTask(@NotNull String saveFileName, @NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        SaveFile saveFile = new SaveFile(saveFileName, null, dataFile, 2, null);
        this.log.debug("writeTask: " + saveFile.getName());
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        IOTask iOTask = fileSystemService.writeDataTask((Serializable)saveFile, saveFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"fs.writeDataTask(saveFile, saveFile.name)");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> readAndLoadTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("readAndLoadTask: " + saveFileName);
        IOTask iOTask = this.readTask(saveFileName).then((Function)new Function<SaveFile, IOTask<Void>>(this){
            final /* synthetic */ SaveLoadService this$0;

            public final IOTask<Void> apply(SaveFile saveFile) {
                return IOTask.ofVoid((Runnable)new Runnable(this, saveFile){
                    final /* synthetic */ readAndLoadTask.1 this$0;
                    final /* synthetic */ SaveFile $saveFile;

                    public final void run() {
                        this.this$0.this$0.load(this.$saveFile.getData());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$saveFile = saveFile;
                    }
                });
            }
            {
                this.this$0 = saveLoadService;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"readTask(saveFileName)\n \u2026      }\n                }");
        return iOTask;
    }

    @NotNull
    public final IOTask<SaveFile> readTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        return fileSystemService.readDataTask(saveFileName);
    }

    @NotNull
    public final IOTask<Void> deleteSaveFileTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("Deleting save file: " + saveFileName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        return fileSystemService.deleteFileTask(saveFileName);
    }

    @NotNull
    public final IOTask<Optional<SaveFile>> readLastModifiedSaveFileTask(@NotNull String dirName, @NotNull String saveFileExt) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)saveFileExt, (String)"saveFileExt");
        this.log.debug("Reading last modified save file from " + dirName + " with ext: " + saveFileExt);
        IOTask iOTask = this.readSaveFilesTask(dirName, saveFileExt).then((Function)new Function<List<? extends SaveFile>, IOTask<Optional<SaveFile>>>(this){
            final /* synthetic */ SaveLoadService this$0;

            public final IOTask<Optional<SaveFile>> apply(List<SaveFile> files) {
                return IOTask.of((String)"findLastSave", (Callable)new Callable<Optional<SaveFile>>(this, files){
                    final /* synthetic */ readLastModifiedSaveFileTask.1 this$0;
                    final /* synthetic */ List $files;

                    public final Optional<SaveFile> call() {
                        if (this.$files.isEmpty()) {
                            SaveLoadService.access$getLog$p(this.this$0.this$0).warning("No save files found");
                            return Optional.empty();
                        }
                        Collections.sort(this.$files, SaveFile.RECENT_FIRST);
                        return Optional.of(this.$files.get(0));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$files = list;
                    }
                });
            }
            {
                this.this$0 = saveLoadService;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"readSaveFilesTask(dirNam\u2026)\n            }\n        }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<SaveFile>> readSaveFilesTask(@NotNull String dirName, @NotNull String saveFileExt) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)saveFileExt, (String)"saveFileExt");
        this.log.debug("Reading save files from " + dirName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        IOTask iOTask = fileSystemService.loadFileNamesTask(dirName, true, CollectionsKt.listOf((Object)new FileExtension(saveFileExt))).then((Function)new Function<List<? extends String>, IOTask<List<? extends SaveFile>>>(this, dirName){
            final /* synthetic */ SaveLoadService this$0;
            final /* synthetic */ String $dirName;

            public final IOTask<List<SaveFile>> apply(List<String> fileNames) {
                return IOTask.of((String)"readSaveFiles", (Callable)new Callable<List<? extends SaveFile>>(this, fileNames){
                    final /* synthetic */ readSaveFilesTask.1 this$0;
                    final /* synthetic */ List $fileNames;

                    public final List<SaveFile> call() {
                        ArrayList<SaveFile> list = new ArrayList<SaveFile>();
                        for (String name : this.$fileNames) {
                            SaveFile file = (SaveFile)SaveLoadService.access$getFs$p(this.this$0.this$0).readDataTask(this.this$0.$dirName + '/' + name).run();
                            if (file == null) continue;
                            list.add(file);
                        }
                        return list;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileNames = list;
                    }
                });
            }
            {
                this.this$0 = saveLoadService;
                this.$dirName = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"fs.loadFileNamesTask(dir\u2026      }\n                }");
        return iOTask;
    }

    public SaveLoadService() {
        boolean bl = false;
        this.saveLoadHandlers = new ArrayList();
    }

    public static final /* synthetic */ Logger access$getLog$p(SaveLoadService $this) {
        return $this.log;
    }

    public static final /* synthetic */ FileSystemService access$getFs$p(SaveLoadService $this) {
        FileSystemService fileSystemService = $this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        return fileSystemService;
    }

    public static final /* synthetic */ void access$setFs$p(SaveLoadService $this, FileSystemService fileSystemService) {
        $this.fs = fileSystemService;
    }
}

