/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.trade;

import com.almasb.fxgl.trade.TradeItem;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0002\u0010\bJ*\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u001aR\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/trade/Shop;", "T", "", "initialMoney", "", "items", "", "Lcom/almasb/fxgl/trade/TradeItem;", "(ILjava/util/List;)V", "Ljavafx/collections/ObservableList;", "getItems", "()Ljavafx/collections/ObservableList;", "value", "money", "getMoney", "()I", "setMoney", "(I)V", "propMoney", "Ljavafx/beans/property/SimpleIntegerProperty;", "buyFrom", "", "other", "item", "qty", "moneyProperty", "Ljavafx/beans/property/IntegerProperty;", "fxgl-trade"})
public final class Shop<T> {
    private final SimpleIntegerProperty propMoney;
    @NotNull
    private final ObservableList<TradeItem<T>> items;

    @NotNull
    public final ObservableList<TradeItem<T>> getItems() {
        return this.items;
    }

    @NotNull
    public final IntegerProperty moneyProperty() {
        return (IntegerProperty)this.propMoney;
    }

    public final int getMoney() {
        Integer n = this.propMoney.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"propMoney.value");
        return n;
    }

    public final void setMoney(int value) {
        this.propMoney.setValue((Number)value);
    }

    public final boolean buyFrom(@NotNull Shop<T> other, @NotNull TradeItem<T> item, int qty) {
        boolean bl;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        if (item.getQuantity() < qty) {
            return false;
        }
        if (!other.items.contains(item)) {
            return false;
        }
        int cost = item.getBuyPrice() * qty;
        if (this.getMoney() < cost) {
            return false;
        }
        Shop shop = this;
        shop.setMoney(shop.getMoney() - cost);
        Shop<T> shop2 = other;
        shop2.setMoney(shop2.getMoney() + cost);
        TradeItem<T> tradeItem = item;
        tradeItem.setQuantity(tradeItem.getQuantity() - qty);
        if (this.items.contains(item)) {
            Object v3;
            block8: {
                iterable = (Iterable)this.items;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    TradeItem it = (TradeItem)t;
                    boolean bl3 = false;
                    if (!(it.getItem() == item.getItem())) continue;
                    v3 = t;
                    break block8;
                }
                v3 = null;
            }
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            TradeItem tradeItem2 = v3;
            tradeItem2.setQuantity(tradeItem2.getQuantity() + qty);
        } else {
            iterable = (Collection)this.items;
            TradeItem<T> tradeItem3 = item.copy();
            boolean bl4 = false;
            boolean bl5 = false;
            TradeItem<T> it = tradeItem3;
            boolean bl6 = false;
            it.setQuantity(qty);
            bl4 = false;
            iterable.add(tradeItem3);
        }
        if (item.getQuantity() == 0) {
            iterable = (Collection)other.items;
            bl = false;
            iterable.remove(item);
        }
        return true;
    }

    public Shop(int initialMoney, @NotNull List<TradeItem<T>> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.propMoney = new SimpleIntegerProperty(initialMoney);
        ObservableList observableList = FXCollections.observableArrayList((Collection)items);
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"FXCollections.observableArrayList(items)");
        this.items = observableList;
    }

    public /* synthetic */ Shop(int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, list);
    }
}

