/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.grammy;

import com.almasb.grammy.EngModifiersKt;
import com.almasb.grammy.Grammar;
import com.almasb.grammy.GrammyConceptsKt;
import com.almasb.grammy.Modifier;
import com.almasb.grammy.Rule;
import com.almasb.grammy.RuntimeSymbol;
import com.almasb.grammy.Symbol;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\tJ\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\tH\u0002J\u0006\u0010%\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/almasb/grammy/Grammar;", "", "random", "Ljava/util/Random;", "(Ljava/util/Random;)V", "getRandom", "()Ljava/util/Random;", "specialSymbols", "Ljava/util/HashMap;", "", "Lkotlin/Function1;", "symbolKeys", "", "getSymbolKeys", "()Ljava/util/List;", "symbols", "Lcom/almasb/grammy/Symbol;", "addSymbol", "", "symbolKey", "ruleset", "applyModifiers", "input", "modifierNames", "expand", "s", "expandAction", "action", "expandSymbol", "key", "expandSymbolOrAction", "flatten", "startSymbolKey", "fromJSON", "json", "getSymbol", "name", "toJSON", "grammy"})
@SourceDebugExtension(value={"SMAP\nGrammyConcepts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrammyConcepts.kt\ncom/almasb/grammy/Grammar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,396:1\n1549#2:397\n1620#2,3:398\n766#2:401\n857#2,2:402\n1549#2:404\n1620#2,3:405\n766#2:408\n857#2,2:409\n1549#2:411\n1620#2,3:412\n1855#2:415\n1856#2:419\n1#3:416\n37#4,2:417\n32#5,2:420\n*S KotlinDebug\n*F\n+ 1 GrammyConcepts.kt\ncom/almasb/grammy/Grammar\n*L\n169#1:397\n169#1:398,3\n293#1:401\n293#1:402,2\n295#1:404\n295#1:405,3\n299#1:408\n299#1:409,2\n301#1:411\n301#1:412,3\n327#1:415\n327#1:419\n338#1:417,2\n358#1:420,2\n*E\n"})
public final class Grammar {
    @NotNull
    private final Random random;
    @NotNull
    private final HashMap<String, Function1<String, String>> specialSymbols;
    @NotNull
    private final HashMap<String, Symbol> symbols;

    public Grammar(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
        this.specialSymbols = new LinkedHashMap();
        ((Map)this.specialSymbols).put("num", new Function1<String, String>(){

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return String.valueOf(this.getRandom().nextInt(Integer.MAX_VALUE));
            }
        });
        this.symbols = new LinkedHashMap();
    }

    public /* synthetic */ Grammar(Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            random = new Random();
        }
        this(random);
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public final List<String> getSymbolKeys() {
        Set<String> set = this.symbols.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"symbols.keys");
        Collection collection = CollectionsKt.toList((Iterable)set);
        Set<String> set2 = this.specialSymbols.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"specialSymbols.keys");
        return CollectionsKt.plus((Collection)collection, (Iterable)set2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addSymbol(@NotNull String symbolKey, @NotNull List<String> ruleset) {
        Collection<Rule> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)symbolKey, (String)"symbolKey");
        Intrinsics.checkNotNullParameter(ruleset, (String)"ruleset");
        Map map = this.symbols;
        Object object = ruleset;
        String string = symbolKey;
        Random random = this.random;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Rule((String)it));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string3 = string;
        Random random2 = random;
        object = new Symbol(random2, string3, list);
        map.put(symbolKey, object);
    }

    @NotNull
    public final String flatten() {
        return this.flatten("origin");
    }

    @NotNull
    public final String flatten(@NotNull String startSymbolKey) {
        Intrinsics.checkNotNullParameter((Object)startSymbolKey, (String)"startSymbolKey");
        String story = CollectionsKt.joinToString$default((Iterable)this.getSymbol(startSymbolKey).getRuleset(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        return this.expand(story);
    }

    @NotNull
    public final String expand(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (!GrammyConceptsKt.access$hasSymbols(s) && !GrammyConceptsKt.access$hasActions(s)) {
            return s;
        }
        String result = s;
        while (GrammyConceptsKt.access$hasSymbols(result) || GrammyConceptsKt.access$hasActions(result)) {
            result = this.expandSymbolOrAction(result);
        }
        return result;
    }

    private final String expandSymbolOrAction(String s) {
        int symbolTagIndex = 0;
        int actionTagIndex = 0;
        boolean insideRegex = false;
        int n = s.length();
        for (int index = 0; index < n; ++index) {
            if (s.charAt(index) == '#') {
                insideRegex = !insideRegex;
                continue;
            }
            if (insideRegex) continue;
            char c = s.charAt(index);
            if (c == '{') {
                symbolTagIndex = index;
                continue;
            }
            if (c == '[') {
                actionTagIndex = index;
                continue;
            }
            if (c == '}') {
                String string = s.substring(symbolTagIndex + 1, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String key = string;
                String expandedText = this.expandSymbol(key);
                int extraChars = 1;
                if (((CharSequence)expandedText).length() == 0) {
                    if (symbolTagIndex > 0 && s.charAt(symbolTagIndex - 1) == ' ') {
                        --symbolTagIndex;
                    } else if (index + 1 < s.length() && s.charAt(index + 1) == ' ') {
                        extraChars = 2;
                    }
                }
                String string2 = s;
                int n2 = index + extraChars;
                return ((Object)StringsKt.replaceRange((CharSequence)string2, (int)symbolTagIndex, (int)n2, (CharSequence)expandedText)).toString();
            }
            if (c != ']') continue;
            String string = s.substring(actionTagIndex + 1, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String action = string;
            this.expandAction(action);
            String string3 = s;
            int n3 = index + 1;
            CharSequence charSequence = "";
            return ((Object)StringsKt.replaceRange((CharSequence)string3, (int)actionTagIndex, (int)n3, (CharSequence)charSequence)).toString();
        }
        throw GrammyConceptsKt.access$error("No symbol or action found");
    }

    private final String expandSymbol(String key) {
        String symbolName = StringsKt.substringBefore$default((String)key, (char)(GrammyConceptsKt.access$hasRegex(key) ? (char)'#' : '.'), null, (int)2, null);
        String regex = GrammyConceptsKt.access$hasRegex(key) ? GrammyConceptsKt.access$substringBetween(key, '#') : "";
        Object object = this.specialSymbols.get(symbolName);
        if (object == null || (object = (String)object.invoke((Object)regex)) == null) {
            object = this.getSymbol(symbolName).selectRule(regex).getText();
        }
        Object newValue = object;
        String expandedText = this.expand((String)newValue);
        if (GrammyConceptsKt.access$hasModifiers(key)) {
            char[] cArray = new char[]{'.'};
            expandedText = this.applyModifiers(expandedText, CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)StringsKt.substringAfterLast$default((String)key, (char)'#', null, (int)2, null), (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1));
        }
        return expandedText;
    }

    /*
     * WARNING - void declaration
     */
    private final void expandAction(String action) {
        if (((CharSequence)action).length() > 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            String it;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            char[] cArray = new char[]{':'};
            List tokens = StringsKt.split$default((CharSequence)action, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String keyWithOp = (String)tokens.get(0);
            char[] cArray2 = new char[]{','};
            List rulesetWithOps = StringsKt.split$default((CharSequence)((CharSequence)tokens.get(1)), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            Iterable iterable = rulesetWithOps;
            boolean $i$f$filter = false;
            void var8_9 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((CharSequence)it, (char)'-', (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                collection.add(new Rule(string));
            }
            List subtractRuleset = (List)destination$iv$iv;
            Iterable $i$f$map22 = rulesetWithOps;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((CharSequence)it2, (char)'-', (boolean)false, (int)2, null))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it2 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(new Rule(GrammyConceptsKt.access$removePrefix(it2, '+')));
            }
            List addRuleset = (List)destination$iv$iv2;
            String key = GrammyConceptsKt.access$removePrefix(keyWithOp, '!');
            if (StringsKt.startsWith$default((CharSequence)keyWithOp, (char)'!', (boolean)false, (int)2, null) || !((Map)this.symbols).containsKey(key)) {
                ((Map)this.symbols).put(key, new RuntimeSymbol(this.random, key, addRuleset));
                return;
            }
            if (((Map)this.symbols).containsKey(key)) {
                Symbol symbol = this.symbols.get(key);
                Intrinsics.checkNotNull((Object)symbol);
                Symbol symbol2 = symbol;
                ((Map)this.symbols).put(key, new Symbol(this.random, key, CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)symbol2.getRuleset(), (Iterable)subtractRuleset), (Iterable)addRuleset)));
            }
        }
    }

    private final Symbol getSymbol(String name) {
        Symbol symbol = this.symbols.get(name);
        if (symbol == null) {
            throw GrammyConceptsKt.access$error("Symbol key \"" + name + "\" not found!");
        }
        return symbol;
    }

    private final String applyModifiers(String input, List<String> modifierNames) {
        String result = null;
        result = input;
        Iterable $this$forEach$iv = modifierNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modifier modifier;
            Object v1;
            String name;
            block7: {
                String[] stringArray;
                name = (String)element$iv;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)name, (char)'(', (boolean)false, (int)2, null)) {
                    Modifier modifier2;
                    Object v0;
                    List params;
                    String modName;
                    block6: {
                        modName = StringsKt.substringBefore$default((String)name, (char)'(', null, (int)2, null);
                        String[] stringArray2 = new String[]{","};
                        params = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)name, (char)'(', null, (int)2, null), (char)')', null, (int)2, null), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                        Iterable iterable = EngModifiersKt.getENG_MODIFIERS();
                        for (Object t : iterable) {
                            Modifier it = (Modifier)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)modName)) continue;
                            v0 = t;
                            break block6;
                        }
                        v0 = null;
                    }
                    if ((Modifier)v0 == null) {
                        throw new IllegalArgumentException("Modifier " + modName + " not found!");
                    }
                    Collection $this$toTypedArray$iv = params;
                    boolean bl2 = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    stringArray = thisCollection$iv.toArray(new String[0]);
                    result = modifier2.apply(this.random, result, Arrays.copyOf(stringArray, stringArray.length));
                    continue;
                }
                stringArray = (String[])EngModifiersKt.getENG_MODIFIERS();
                for (Object t : stringArray) {
                    Modifier it = (Modifier)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            if ((Modifier)v1 == null) {
                throw new IllegalArgumentException("Modifier " + name + " not found!");
            }
            result = modifier.apply(this.random, result, new String[0]);
        }
        return result;
    }

    public final void fromJSON(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.symbols.clear();
        JsonNode rootObject = new ObjectMapper().readTree(json);
        Iterator iterator = rootObject.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"rootObject.fields()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            this.addSymbol(string, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)v)), (Function1)fromJSON.1.1.INSTANCE)));
        }
    }

    @NotNull
    public final String toJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        this.symbols.forEach((arg_0, arg_1) -> Grammar.toJSON$lambda$9((Function2)new Function2<String, Symbol, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;
            {
                this.$sb = $sb;
                super(2);
            }

            public final void invoke(@NotNull String key, @NotNull Symbol symbol) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                this.$sb.append("  \"" + key + "\": " + CollectionsKt.joinToString((Iterable)symbol.getRuleset(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)-1, (CharSequence)"...", (Function1)toJSON.1.INSTANCE) + ",\n");
            }
        }, arg_0, arg_1));
        sb.deleteCharAt(sb.length() - 2);
        sb.append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final void toJSON$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public Grammar() {
        this(null, 1, null);
    }
}

