/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.grammy;

import com.almasb.grammy.GrammyConceptsKt;
import com.almasb.grammy.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0012\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0005R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/grammy/Symbol;", "", "random", "Ljava/util/Random;", "key", "", "ruleset", "", "Lcom/almasb/grammy/Rule;", "(Ljava/util/Random;Ljava/lang/String;Ljava/util/List;)V", "distributions", "Ljava/util/HashMap;", "Lkotlin/ranges/IntRange;", "Lkotlin/collections/HashMap;", "getKey", "()Ljava/lang/String;", "getRandom", "()Ljava/util/Random;", "getRuleset", "()Ljava/util/List;", "withoutDistr", "selectRule", "regex", "grammy"})
@SourceDebugExtension(value={"SMAP\nGrammyConcepts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrammyConcepts.kt\ncom/almasb/grammy/Symbol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n766#2:397\n857#2,2:398\n1855#2,2:400\n766#2:402\n857#2,2:403\n*S KotlinDebug\n*F\n+ 1 GrammyConcepts.kt\ncom/almasb/grammy/Symbol\n*L\n78#1:397\n78#1:398,2\n83#1:400,2\n106#1:402\n106#1:403,2\n*E\n"})
class Symbol {
    @NotNull
    private final Random random;
    @NotNull
    private final String key;
    @NotNull
    private final List<Rule> ruleset;
    @NotNull
    private final HashMap<IntRange, Rule> distributions;
    @NotNull
    private final List<Rule> withoutDistr;

    /*
     * WARNING - void declaration
     */
    public Symbol(@NotNull Random random, @NotNull String key, @NotNull List<Rule> ruleset) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(ruleset, (String)"ruleset");
        this.random = random;
        this.key = key;
        this.ruleset = ruleset;
        this.distributions = new HashMap();
        if (((CharSequence)this.key).length() == 0) {
            throw GrammyConceptsKt.access$error("Symbol key cannot be empty");
        }
        if (this.ruleset.isEmpty()) {
            throw GrammyConceptsKt.access$error("Ruleset for " + this.key + " is empty");
        }
        Iterable $this$filter$iv = this.ruleset;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Rule it = (Rule)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it.getText(), (String)")", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List withDistributions = (List)destination$iv$iv;
        this.withoutDistr = CollectionsKt.minus((Iterable)this.ruleset, (Iterable)withDistributions);
        int bound = 0;
        Iterable $this$forEach$iv = withDistributions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rule it = (Rule)element$iv;
            boolean bl = false;
            int dist = Integer.parseInt(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it.getText(), (char)'(', null, (int)2, null), (char)')', null, (int)2, null));
            IntRange range = RangesKt.until((int)bound, (int)(bound + dist));
            ((Map)this.distributions).put(range, new Rule(StringsKt.removeSuffix((String)it.getText(), (CharSequence)("" + '(' + dist + ')'))));
            bound += dist;
        }
        if (bound > 100) {
            throw GrammyConceptsKt.access$error("Rule distributions for " + this.key + " are greater than 100%");
        }
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final List<Rule> getRuleset() {
        return this.ruleset;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rule selectRule(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        if (((CharSequence)regex).length() > 0) {
            void $this$filterTo$iv$iv;
            Collection<Rule> collection = this.distributions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"distributions.values");
            Iterable $this$filter$iv = CollectionsKt.plus(collection, (Iterable)this.withoutDistr);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Rule it = (Rule)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getText();
                if (!new Regex(regex).matches(charSequence)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List valid = (List)destination$iv$iv;
            if (valid.isEmpty()) {
                throw GrammyConceptsKt.access$error("No matching rule found");
            }
            Object e = valid.get(this.random.nextInt(valid.size()));
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid[random.nextInt(valid.size)]");
            return (Rule)e;
        }
        if (!((Map)this.distributions).isEmpty()) {
            int randomValue = this.random.nextInt(100);
            for (Map.Entry entry : ((Map)this.distributions).entrySet()) {
                IntRange distr = (IntRange)entry.getKey();
                Rule rule = (Rule)entry.getValue();
                int n = distr.getFirst();
                boolean bl = randomValue <= distr.getLast() ? n <= randomValue : false;
                if (!bl) continue;
                return rule;
            }
        }
        return this.withoutDistr.get(this.random.nextInt(this.withoutDistr.size()));
    }
}

