/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.shared.NoReaderForLangException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import pellet.Pellet;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public abstract class PelletCmdApp {
    public static final Logger logger = Logger.getLogger(PelletCmdApp.class.getName());
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private static final RDFReaderF READER_FACTORY = ModelFactory.createDefaultModel();
    protected String appId;
    protected String appCmd;
    protected String help;
    protected PelletCmdOptions options = this.getOptions();
    private List<String> inputFiles;
    protected KBLoader loader;
    protected boolean verbose;
    protected Timers timers;
    protected List<String> tasks;

    public PelletCmdApp() {
        this.appId = this.getAppId();
        this.appCmd = this.getAppCmd();
        this.inputFiles = new ArrayList<String>();
        this.timers = new Timers();
        this.buildHelp();
    }

    public boolean requiresInputFiles() {
        return true;
    }

    protected void verbose(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    protected void output(String msg) {
        System.out.println(msg);
    }

    protected void output(Model model) {
        model.write((OutputStream)System.out);
    }

    public abstract String getAppId();

    public abstract String getAppCmd();

    public abstract PelletCmdOptions getOptions();

    public abstract void run();

    public void finish() {
        if (this.verbose) {
            StringWriter sw = new StringWriter();
            this.timers.print((Writer)sw, true, null);
            this.verbose("");
            this.verbose("Timer summary:");
            this.verbose(sw.toString());
        }
    }

    protected String getMandatoryOptions() {
        StringBuffer ret = new StringBuffer();
        Set<PelletCmdOption> mandatory = this.options.getMandatoryOptions();
        for (PelletCmdOption option : mandatory) {
            ret.append("-" + option.getShortOption() + " arg ");
        }
        return ret.toString();
    }

    public PelletCmdOption getIgnoreImportsOption() {
        PelletCmdOption option = new PelletCmdOption("ignore-imports");
        option.setDescription("Ignore imported ontologies");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        return option;
    }

    public PelletCmdOption getLoaderOption() {
        PelletCmdOption option = new PelletCmdOption("loader");
        option.setShortOption("l");
        option.setDescription("Use Jena, OWLAPI, OWLAPIv3 or KRSS to load the ontology");
        option.setType("Jena | OWLAPI | OWLAPIv3 | KRSS");
        option.setDefaultValue("OWLAPIv3");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        return option;
    }

    public PelletCmdOptions getGlobalOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption helpOption = new PelletCmdOption("help");
        helpOption.setShortOption("h");
        helpOption.setDescription("Print this message");
        helpOption.setDefaultValue(false);
        helpOption.setIsMandatory(false);
        helpOption.setArg(PelletCmdOptionArg.NONE);
        options.add(helpOption);
        PelletCmdOption verboseOption = new PelletCmdOption("verbose");
        verboseOption.setShortOption("v");
        verboseOption.setDescription("Print full stack trace for errors.");
        verboseOption.setDefaultValue(false);
        verboseOption.setIsMandatory(false);
        verboseOption.setArg(PelletCmdOptionArg.NONE);
        options.add(verboseOption);
        PelletCmdOption configOption = new PelletCmdOption("config");
        configOption.setShortOption("C");
        configOption.setDescription("Use the selected configuration file");
        configOption.setIsMandatory(false);
        configOption.setType("configuration file");
        configOption.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(configOption);
        return options;
    }

    public PelletCmdOption getInputFormatOption() {
        PelletCmdOption option = new PelletCmdOption("input-format");
        option.setDefaultValue(null);
        option.setDescription("Format of the input file (valid only for the Jena loader). Default behaviour is to guess the input format based on the file extension.");
        option.setType("RDF/XML | Turtle | N-Triples");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        return option;
    }

    protected KnowledgeBase getKB() {
        return this.getKB(this.getLoader());
    }

    protected KnowledgeBase getKB(KBLoader loader) {
        try {
            String[] inputFiles = this.getInputFiles();
            this.verbose("There are " + inputFiles.length + " input files:");
            for (String inputFile : inputFiles) {
                this.verbose(inputFile);
            }
            this.startTask("loading");
            KnowledgeBase kb = loader.createKB(inputFiles);
            this.finishTask("loading");
            if (this.verbose) {
                StringBuilder sb = new StringBuilder();
                sb.append("Classes = " + kb.getAllClasses().size() + ", ");
                sb.append("Properties = " + kb.getProperties().size() + ", ");
                sb.append("Individuals = " + kb.getIndividuals().size());
                this.verbose("Input size: " + sb);
                this.verbose("Expressivity: " + kb.getExpressivity());
            }
            return kb;
        }
        catch (RuntimeException e) {
            throw new PelletCmdException(e);
        }
    }

    protected KBLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        String loaderName = this.options.getOption("loader").getValueAsString();
        return this.getLoader(loaderName);
    }

    protected KBLoader getLoader(String loaderName) {
        if (loaderName.equalsIgnoreCase("Jena")) {
            this.loader = new JenaLoader();
        } else if (loaderName.equalsIgnoreCase("OWLAPIv3")) {
            this.loader = new OWLAPILoader();
        } else if (loaderName.equalsIgnoreCase("KRSS")) {
            this.loader = new KRSSLoader();
        } else {
            throw new PelletCmdException("Unknown loader: " + loaderName);
        }
        this.loader.setIgnoreImports(this.options.getOption("ignore-imports").getValueAsBoolean());
        PelletCmdOption option = this.options.getOption("input-format");
        if (option != null && option.getValueAsString() != null && this.loader instanceof JenaLoader) {
            String inputFormat = option.getValueAsString().toUpperCase();
            try {
                if (inputFormat != null) {
                    READER_FACTORY.getReader(inputFormat.toUpperCase());
                    ((JenaLoader)this.loader).setInputFormat(inputFormat);
                }
            }
            catch (NoReaderForLangException e) {
                throw new PelletCmdException("Unrecognized input format: " + inputFormat);
            }
        }
        return this.loader;
    }

    protected String[] getInputFiles() {
        return this.inputFiles.toArray(new String[0]);
    }

    private void buildHelp() {
        StringBuffer u = new StringBuffer();
        HelpTable table = new HelpTable(this.options);
        u.append(this.appId + LINE_BREAK + LINE_BREAK);
        u.append("Usage: " + this.appCmd + LINE_BREAK + LINE_BREAK);
        u.append(table.print() + LINE_BREAK);
        this.help = u.toString();
    }

    public void parseArgs(String[] args) {
        int i;
        HashSet<String> seenOptions = new HashSet<String>();
        block5: for (i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--")) {
                return;
            }
            if (arg.charAt(0) != '-') break;
            PelletCmdOption option = this.options.getOption(arg = arg.charAt(1) == '-' ? arg.substring(2) : arg.substring(1));
            if (option == null) {
                throw new PelletCmdException("Unrecognized option: " + arg);
            }
            if (option.getLongOption().equals("help")) {
                this.help();
            } else if (option.getLongOption().equals("verbose")) {
                Pellet.exceptionFormatter.setVerbose(true);
            }
            if (seenOptions.contains(option.getLongOption())) {
                throw new PelletCmdException("Repeated use of option: " + arg);
            }
            seenOptions.add(option.getLongOption());
            PelletCmdOptionArg optionArg = option.getArg();
            boolean nextIsArg = args.length > i + 1 && args[i + 1].charAt(0) != '-';
            switch (optionArg) {
                case NONE: {
                    option.setValue(true);
                    continue block5;
                }
                case REQUIRED: {
                    if (!nextIsArg) {
                        throw new PelletCmdException("Option <" + option.getLongOption() + "> requires an argument");
                    }
                    option.setValue(args[++i]);
                    continue block5;
                }
                case OPTIONAL: {
                    if (nextIsArg) {
                        option.setValue(args[++i]);
                        continue block5;
                    }
                    option.setExists(true);
                    continue block5;
                }
                default: {
                    throw new PelletCmdException("Unrecognized option argument: " + (Object)((Object)optionArg));
                }
            }
        }
        for (PelletCmdOption option : this.options.getOptions()) {
            if (!option.isMandatory() || option.getValue() != null) continue;
            throw new PelletCmdException("Option <" + option.getLongOption() + "> is mandatory");
        }
        this.loadConfig();
        while (i < args.length) {
            this.inputFiles.add(args[i]);
            ++i;
        }
        if (this.options.getOption("verbose").getValueAsBoolean()) {
            this.verbose = true;
        }
        if (this.requiresInputFiles()) {
            if (this.inputFiles.isEmpty()) {
                throw new PelletCmdException("No input file given");
            }
        } else if (!this.inputFiles.isEmpty()) {
            throw new PelletCmdException("Unexpected argument(s): " + this.inputFiles);
        }
    }

    private void loadConfig() {
        String configFile = this.options.getOption("config").getValueAsString();
        if (configFile != null) {
            try {
                URL url = new URL("file:" + configFile);
                PelletOptions.load((URL)url);
            }
            catch (MalformedURLException e) {
                throw new PelletCmdException("Invalid URL given for the config file: " + configFile);
            }
            catch (FileNotFoundException e) {
                throw new PelletCmdException("The specified configuration file cannot be found: " + configFile);
            }
            catch (IOException e) {
                throw new PelletCmdException("I/O error while reading the configuration file: " + e.toString());
            }
        }
    }

    public void help() {
        this.output(this.help);
        System.exit(0);
    }

    protected void startTask(String task) {
        this.verbose("Start " + task);
        this.timers.startTimer(task);
    }

    protected void finishTask(String task) {
        Timer timer = this.timers.getTimer(task);
        timer.stop();
        this.verbose("Finished " + task + " in " + timer.format());
    }

    private static class HelpTable {
        private final String LINE_BREAK = System.getProperty("line.separator");
        private PelletCmdOptions options;
        private int maxLineWidth = 80;
        private int indent = 5;

        public HelpTable(PelletCmdOptions options) {
            this.options = options;
        }

        public String print() {
            StringBuffer ret = new StringBuffer();
            ret.append("Argument description:" + this.LINE_BREAK + this.LINE_BREAK);
            int i = 0;
            boolean last = false;
            for (PelletCmdOption option : this.options.getOptions()) {
                if (++i == this.options.getOptions().size()) {
                    last = true;
                }
                String longOption = option.getLongOption();
                String shortOption = option.getShortOption();
                String type = option.getType();
                PelletCmdOptionArg arg = option.getArg();
                String description = option.getDescription();
                String defaultValue = "";
                if (option.getDefaultValue() != null) {
                    defaultValue = option.getDefaultValue().toString();
                }
                String firstLine = this.firstLine(shortOption, longOption, type, arg);
                String secondLine = this.secondLine(description, defaultValue);
                ret.append(firstLine);
                ret.append(this.LINE_BREAK);
                ret.append(secondLine);
                if (last) continue;
                ret.append(this.LINE_BREAK + this.LINE_BREAK);
            }
            return ret.toString();
        }

        private String fill(int n) {
            return this.draw(" ", n);
        }

        private String draw(String c, int n) {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                ret.append(c);
            }
            return ret.toString();
        }

        private String firstLine(String shortOption, String longOption, String type, PelletCmdOptionArg arg) {
            StringBuffer ret = new StringBuffer();
            ret.append("--" + longOption);
            if (shortOption != null) {
                ret.append(", -" + shortOption);
            }
            ret.append(" ");
            if (type != null) {
                if (arg.equals((Object)PelletCmdOptionArg.OPTIONAL) && !type.startsWith("[") && !type.startsWith("(")) {
                    ret.append("[" + type + "] ");
                } else if (arg.equals((Object)PelletCmdOptionArg.REQUIRED) && !type.startsWith("[") && !type.startsWith("(")) {
                    ret.append("(" + type + ") ");
                }
            }
            return ret.toString();
        }

        private String secondLine(String description, String defaultValue) {
            int colStart;
            int colLength = colStart = this.indent;
            StringBuffer ret = new StringBuffer();
            if (description == null && defaultValue == null) {
                return ret.toString();
            }
            String tokens = defaultValue != null && defaultValue.length() != 0 && !defaultValue.equals("true") && !defaultValue.equals("false") ? description + " (Default: " + defaultValue + ")" : description;
            ret.append(this.fill(colStart));
            StringTokenizer tokenizer = new StringTokenizer(tokens);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((colLength = colLength + token.length() + 1) > this.maxLineWidth) {
                    ret.append(this.LINE_BREAK + this.fill(colStart));
                    colLength = colStart + token.length() + 1;
                }
                ret.append(token + " ");
            }
            return ret.toString();
        }
    }
}

