/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;

public class PelletCmdOptions {
    private Map<String, PelletCmdOption> options = new LinkedHashMap<String, PelletCmdOption>();
    private Map<String, PelletCmdOption> shortOptions = new HashMap<String, PelletCmdOption>();
    private Set<PelletCmdOption> mandatory = new HashSet<PelletCmdOption>();

    public void add(PelletCmdOption option) {
        String shortOption = option.getShortOption();
        String longOption = option.getLongOption();
        if (this.options.containsKey(longOption)) {
            throw new PelletCmdException("Duplicate long option for command: " + longOption);
        }
        if (shortOption != null && this.shortOptions.containsKey(shortOption)) {
            throw new PelletCmdException("Duplicate short option for command: " + shortOption);
        }
        this.shortOptions.put(shortOption, option);
        this.options.put(longOption, option);
        if (option.isMandatory()) {
            this.mandatory.add(option);
        }
    }

    public PelletCmdOption getOption(String key) {
        PelletCmdOption option = this.shortOptions.get(key);
        if (option == null) {
            option = this.options.get(key);
        }
        return option;
    }

    public Set<PelletCmdOption> getMandatoryOptions() {
        return this.mandatory;
    }

    public Collection<PelletCmdOption> getOptions() {
        return this.options.values();
    }
}

