/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import pellet.PelletCmdException;

public class PelletExceptionFormatter {
    private boolean verbose = false;

    public String formatException(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (!this.verbose) {
            if (cause instanceof FileNotFoundException) {
                return this.format((FileNotFoundException)cause);
            }
            if (cause instanceof PelletCmdException) {
                return this.format((PelletCmdException)cause);
            }
            return this.formatGeneric(cause);
        }
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        cause.printStackTrace(pw);
        pw.close();
        return writer.toString();
    }

    private String format(FileNotFoundException e) {
        return "ERROR: Cannot open " + e.getMessage();
    }

    private String format(PelletCmdException e) {
        return "ERROR: " + e.getMessage();
    }

    private String formatGeneric(Throwable e) {
        int index;
        String msg = e.getMessage();
        if (msg != null && (index = msg.indexOf(10, 0)) != -1) {
            msg = msg.substring(0, index);
        }
        return msg + "\nUse -v for detail.";
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

