/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class PelletModularity
extends PelletCmdApp {
    private OWLAPILoader loader;
    private ModuleType moduleType;
    private String[] entityNames;

    @Override
    public String getAppCmd() {
        return "pellet modularity " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletModularity: Extract ontology modules for classes and write it to the STDOUT";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getIgnoreImportsOption());
        PelletCmdOption option = new PelletCmdOption("signature");
        option.setShortOption("s");
        option.setType("Space separated list");
        option.setDescription("One or more entity URI(s) or local name(s) to be extracted as a module. Example: \"Animal Wildlife Rainforest\"");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("type");
        option.setShortOption("t");
        option.setType("lower| upper | upper-of-lower | lower-of-upper");
        option.setDefaultValue("lower");
        option.setDescription("The type of the module that will be extracted. See http://bit.ly/ontology-module-types for an explanation of the module types.");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        return options;
    }

    @Override
    public void run() {
        this.loadEntityNames();
        this.loadModuleType();
        this.loadOntology();
        this.extractModule();
    }

    private void loadOntology() {
        this.loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
    }

    private void loadEntityNames() {
        String signature = this.options.getOption("signature").getValueAsString();
        if (signature == null) {
            throw new PelletCmdException("No signature provided");
        }
        this.entityNames = signature.split(" ");
        if (this.entityNames.length == 0) {
            throw new PelletCmdException("No signature provided");
        }
    }

    private void loadModuleType() {
        String type = this.options.getOption("type").getValueAsString();
        if (type.equalsIgnoreCase("lower")) {
            this.moduleType = ModuleType.TOP;
        } else if (type.equalsIgnoreCase("upper")) {
            this.moduleType = ModuleType.BOT;
        } else if (type.equalsIgnoreCase("upper-of-lower")) {
            this.moduleType = ModuleType.BOT_OF_TOP;
        } else if (type.equalsIgnoreCase("lower-of-upper")) {
            this.moduleType = ModuleType.TOP_OF_BOT;
        } else {
            throw new PelletCmdException("Unknown module type: " + type);
        }
    }

    private void extractModule() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (String entityName : this.entityNames) {
            OWLEntity entity = OntologyUtils.findEntity((String)entityName, (Set)this.loader.getAllOntologies());
            if (entity == null) {
                throw new PelletCmdException("Entity not found in ontology: " + entityName);
            }
            entities.add(entity);
        }
        Set module = ModularityUtils.extractModule((OWLOntology)this.loader.getOntology(), entities, (ModuleType)this.moduleType);
        try {
            OWLOntology moduleOnt = this.loader.getManager().createOntology(module);
            this.loader.getManager().saveOntology(moduleOnt, (OWLOntologyFormat)new RDFXMLOntologyFormat(), (OWLOntologyDocumentTarget)new SystemOutDocumentTarget());
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }
}

