/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.clarkparsia.sparqlowl.parser.arq.ARQTerpParser;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.output.TableData;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletQuery
extends PelletCmdApp {
    private String queryFile;
    private String queryString;
    private Query query;
    private JenaLoader loader;
    private ResultSet queryResults;
    private Model constructQueryModel;
    private boolean askQueryResult;
    private Syntax queryFormat = Syntax.syntaxSPARQL;
    private OutputFormat outputFormat = OutputFormat.TABULAR;
    private SparqlDLExecutionFactory.QueryEngineType queryEngine = null;

    @Override
    public String getAppId() {
        return "PelletQuery: SPARQL-DL Query Engine";
    }

    @Override
    public String getAppCmd() {
        return "pellet query " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        PelletCmdOption option = new PelletCmdOption("query-file");
        option.setShortOption("q");
        option.setType("<file URI>");
        option.setDescription("Read the SPARQL query from the given file");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("output-format");
        option.setShortOption("o");
        option.setType("Tabular | XML | JSON");
        option.setDescription("Format of result set (SELECT queries)");
        option.setDefaultValue("Tabular");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("query-format");
        option.setType("SPARQL | ARQ | TERP");
        option.setDescription("The query format");
        option.setDefaultValue("SPARQL");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        option = new PelletCmdOption("query-engine");
        option.setType("Pellet | ARQ | Mixed");
        option.setShortOption("e");
        option.setDescription("The query engine that will be used. Default behavior is to auto select the engine that can handle the given query with best performance. Pellet query engine is the typically fastest but cannot handle FILTER, OPTIONAL, UNION, DESCRIBE or named graphs. Mixed engine uses ARQ to handle SPARQL algebra and uses Pellet to answer Basic Graph Patterns (BGP) which can be expressed in SPARQL-DL. ARQ engine uses Pellet to answer single triple patterns and can handle queries that do not fit into SPARQL-DL. As a consequence SPARQL-DL extensions and complex class expressions encoded inside the SPARQL query are not supported.");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("bnode");
        option.setDescription("Treat bnodes in the query as undistinguished variables. Undistinguished variables can match individuals whose existence is inferred by the reasoner, e.g. due to a someValuesFrom restriction. This option has no effect if ARQ engine is selected.");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    @Override
    public void parseArgs(String[] args) {
        super.parseArgs(args);
        this.setQueryFile(this.options.getOption("query-file").getValueAsString());
        this.setOutputFormat(this.options.getOption("output-format").getValueAsString());
        this.setQueryFormat(this.options.getOption("query-format").getValueAsString());
        this.setQueryEngine(this.options.getOption("query-engine").getValueAsString());
        PelletOptions.TREAT_ALL_VARS_DISTINGUISHED = !this.options.getOption("bnode").getValueAsBoolean();
    }

    @Override
    public void run() {
        this.loadQuery();
        this.loadInput();
        this.execQuery();
        this.printQueryResults();
    }

    public void setQueryFile(String s) {
        this.queryFile = s;
    }

    public void setOutputFormat(String s) {
        if (s == null) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (s.equalsIgnoreCase("Tabular")) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (s.equalsIgnoreCase("XML")) {
            this.outputFormat = OutputFormat.XML;
        } else if (s.equalsIgnoreCase("JSON")) {
            this.outputFormat = OutputFormat.JSON;
        } else {
            throw new PelletCmdException("Invalid output format: " + (Object)((Object)this.outputFormat));
        }
    }

    public ResultSet getQueryResults() {
        return this.queryResults;
    }

    public Model getConstructQueryModel() {
        return this.constructQueryModel;
    }

    public boolean getAskQueryResult() {
        return this.askQueryResult;
    }

    public void setQueryFormat(String s) {
        if (s == null) {
            throw new PelletCmdException("Query format is null");
        }
        if (s.equalsIgnoreCase("SPARQL")) {
            this.queryFormat = Syntax.lookup((String)"SPARQL");
        } else if (s.equalsIgnoreCase("ARQ")) {
            this.queryFormat = Syntax.lookup((String)"ARQ");
        } else if (s.equalsIgnoreCase("TERP")) {
            this.queryFormat = Syntax.lookup((String)"TERP");
        } else {
            throw new PelletCmdException("Unknown query format: " + s);
        }
        if (this.queryFormat == null) {
            throw new PelletCmdException("Query format is null: " + s);
        }
    }

    public void setQueryEngine(String s) {
        if (s == null) {
            this.queryEngine = null;
            return;
        }
        try {
            this.queryEngine = SparqlDLExecutionFactory.QueryEngineType.valueOf((String)s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PelletCmdException("Unknown query engine: " + s);
        }
    }

    private void loadInput() {
        try {
            this.loader = (JenaLoader)this.getLoader("Jena");
            KnowledgeBase kb = this.getKB((KBLoader)this.loader);
            this.startTask("consistency check");
            boolean isConsistent = kb.isConsistent();
            this.finishTask("consistency check");
            if (!isConsistent) {
                throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
            }
        }
        catch (NotFoundException e) {
            throw new PelletCmdException(e);
        }
        catch (QueryParseException e) {
            throw new PelletCmdException(e);
        }
        catch (InconsistentOntologyException e) {
            throw new PelletCmdException("Cannot query inconsistent ontology!");
        }
    }

    private void loadQuery() {
        try {
            this.verbose("Query file: " + this.queryFile);
            this.startTask("parsing query file");
            this.queryString = FileManager.get().readWholeFileAsUTF8(this.queryFile);
            this.query = QueryFactory.create((String)this.queryString, (Syntax)this.queryFormat);
            this.finishTask("parsing query file");
            this.verbose("Query: ");
            this.verbose("-----------------------------------------------------");
            this.verbose(this.queryString.trim());
            this.verbose("-----------------------------------------------------");
        }
        catch (NotFoundException e) {
            throw new PelletCmdException(e);
        }
        catch (QueryParseException e) {
            throw new PelletCmdException(e);
        }
    }

    private void execQuery() {
        DataSource dataset = DatasetFactory.create((Model)this.loader.getModel());
        QueryExecution qe = this.queryEngine == null ? SparqlDLExecutionFactory.create((Query)this.query, (Dataset)dataset) : SparqlDLExecutionFactory.create((Query)this.query, (Dataset)dataset, null, (SparqlDLExecutionFactory.QueryEngineType)this.queryEngine);
        this.verbose("Created query engine: " + qe.getClass().getName());
        this.startTask("query execution");
        if (this.query.isSelectType()) {
            this.queryResults = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
        } else if (this.query.isConstructType()) {
            this.constructQueryModel = qe.execConstruct();
        } else if (this.query.isAskType()) {
            this.askQueryResult = qe.execAsk();
        } else {
            throw new UnsupportedOperationException("Unsupported query type");
        }
        this.finishTask("query execution");
    }

    private void printQueryResults() {
        if (this.query.isSelectType()) {
            this.printSelectQueryResuts();
        } else if (this.query.isConstructType()) {
            this.printConstructQueryResults();
        } else if (this.query.isAskType()) {
            this.printAskQueryResult();
        }
    }

    private void printSelectQueryResuts() {
        if (this.queryResults.hasNext()) {
            if (this.outputFormat == OutputFormat.TABULAR) {
                this.printTabularQueryResults();
            } else if (this.outputFormat == OutputFormat.XML) {
                this.printXMLQueryResults();
            } else if (this.outputFormat == OutputFormat.JSON) {
                this.printJSONQueryResults();
            } else {
                this.printTabularQueryResults();
            }
        } else {
            this.output("Query Results (0 answers): ");
            this.output("NO RESULTS");
        }
    }

    private void printTabularQueryResults() {
        int count = 0;
        NodeFormatter formatter = new NodeFormatter((Model)this.loader.getModel());
        List resultVars = this.query.getResultVars();
        ArrayList data = new ArrayList();
        while (this.queryResults.hasNext()) {
            QuerySolution binding = this.queryResults.nextSolution();
            ArrayList<String> formattedBinding = new ArrayList<String>();
            for (int i = 0; i < resultVars.size(); ++i) {
                String var = (String)resultVars.get(i);
                RDFNode result = binding.get(var);
                formattedBinding.add(formatter.format(result));
            }
            if (!data.add(formattedBinding)) continue;
            ++count;
        }
        this.output("Query Results (" + count + " answers): ");
        TableData table = new TableData(data, resultVars);
        StringWriter tableSW = new StringWriter();
        table.print((Writer)tableSW);
        this.output(tableSW.toString());
    }

    private void printXMLQueryResults() {
        ResultSetFormatter.outputAsXML((ResultSet)this.queryResults);
    }

    private void printJSONQueryResults() {
        if (this.verbose) {
            System.out.println("/* ");
            System.out.println(this.queryString.replace("*/", "* /"));
            System.out.println("*/ ");
        }
        ResultSetFormatter.outputAsJSON((ResultSet)this.queryResults);
    }

    private void printConstructQueryResults() {
        StringWriter modelSW = new StringWriter();
        this.constructQueryModel.write((Writer)modelSW);
        this.output(modelSW.toString());
    }

    private void printAskQueryResult() {
        this.output("ASK query result: ");
        this.output(this.askQueryResult ? "yes" : "no");
    }

    static {
        ARQTerpParser.registerFactory();
    }

    private static enum OutputFormat {
        TABULAR,
        XML,
        JSON;

    }
}

