/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.github.ansell.shp.WGS84;
import java.util.Locale;

public class UTM {
    private double easting;
    private double northing;
    private int zone;
    private char letter;

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public int getZone() {
        return this.zone;
    }

    public char getLetter() {
        return this.letter;
    }

    public String toString() {
        return String.format("%s %c %s %s", this.zone, Character.valueOf(this.letter), this.easting, this.northing);
    }

    public boolean equals(Object o) {
        if (o instanceof UTM) {
            UTM other = (UTM)o;
            return this.zone == other.zone && this.letter == other.letter && this.easting == other.easting && this.northing == other.northing;
        }
        return false;
    }

    public int hashCode() {
        long least = Double.doubleToRawLongBits(this.easting);
        long lnort = Double.doubleToRawLongBits(this.northing);
        long x = least ^ lnort;
        return (int)(x ^ x >>> 32);
    }

    public UTM(int zone, char letter, double easting, double northing) {
        this.zone = zone;
        this.letter = Character.toUpperCase(letter);
        this.easting = easting;
        this.northing = northing;
    }

    public UTM(String utm) {
        String[] parts = utm.split(" ");
        this.zone = Integer.parseInt(parts[0]);
        this.letter = parts[1].toUpperCase(Locale.ENGLISH).charAt(0);
        this.easting = Double.parseDouble(parts[2]);
        this.northing = Double.parseDouble(parts[3]);
    }

    public static UTM fromWGS84(WGS84 wgs) {
        return UTM.fromWGS84(wgs.getLatitude(), wgs.getLongitude());
    }

    public static UTM fromWGS84(double latitude, double longitude) {
        int zone = (int)Math.floor(longitude / 6.0 + 31.0);
        char letter = latitude < -72.0 ? (char)'C' : (latitude < -64.0 ? (char)'D' : (latitude < -56.0 ? (char)'E' : (latitude < -48.0 ? (char)'F' : (latitude < -40.0 ? (char)'G' : (latitude < -32.0 ? (char)'H' : (latitude < -24.0 ? (char)'J' : (latitude < -16.0 ? (char)'K' : (latitude < -8.0 ? (char)'L' : (latitude < 0.0 ? (char)'M' : (latitude < 8.0 ? (char)'N' : (latitude < 16.0 ? (char)'P' : (latitude < 24.0 ? (char)'Q' : (latitude < 32.0 ? (char)'R' : (latitude < 40.0 ? (char)'S' : (latitude < 48.0 ? (char)'T' : (latitude < 56.0 ? (char)'U' : (latitude < 64.0 ? (char)'V' : (latitude < 72.0 ? (char)'W' : 'X'))))))))))))))))));
        double easting = 0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))) * 0.9996 * 6399593.62 / Math.pow(1.0 + Math.pow(0.0820944379, 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0), 0.5) * (1.0 + Math.pow(0.0820944379, 2.0) / 2.0 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) / 3.0) + 500000.0;
        easting = (double)Math.round(easting * 100.0) * 0.01;
        double northing = (Math.atan(Math.tan(latitude * Math.PI / 180.0) / Math.cos(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) - latitude * Math.PI / 180.0) * 0.9996 * 6399593.625 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) * (1.0 + 0.003369748371 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) + 6397033.7875500005 * (latitude * Math.PI / 180.0 - 0.005054622556 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + 4.258201531E-5 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 - 1.674057895E-7 * (5.0 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 3.0);
        if (letter < 'M') {
            northing += 1.0E7;
        }
        northing = (double)Math.round(northing * 100.0) * 0.01;
        return new UTM(zone, letter, easting, northing);
    }
}

