/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.github.ansell.shp.UTM;

public class WGS84 {
    private double latitude;
    private double longitude;

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public WGS84(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String toString() {
        return String.format("%s %s", this.latitude, this.longitude);
    }

    public boolean equals(Object o) {
        if (o instanceof WGS84) {
            WGS84 other = (WGS84)o;
            return this.latitude == other.latitude && this.longitude == other.longitude;
        }
        return false;
    }

    public int hashCode() {
        long llat = Double.doubleToRawLongBits(this.latitude);
        long llon = Double.doubleToRawLongBits(this.longitude);
        long x = llat ^ llon;
        return (int)(x ^ x >>> 32);
    }

    public static WGS84 fromUTM(UTM utmValue) {
        return WGS84.fromUTM(utmValue.getZone(), utmValue.getLetter(), utmValue.getEasting(), utmValue.getNorthing());
    }

    public static WGS84 fromUTM(int zone, char letter, double easting, double northing) {
        double north = letter > 'M' ? northing : northing - 1.0E7;
        double latitude = (north / 6366197.724 / 0.9996 + (1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) - 0.006739496742 * Math.sin(north / 6366197.724 / 0.9996) * Math.cos(north / 6366197.724 / 0.9996) * (Math.atan(Math.cos(Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996))) * Math.tan((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) - north / 6366197.724 / 0.9996) * 3.0 / 2.0) * (Math.atan(Math.cos(Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996))) * Math.tan((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) - north / 6366197.724 / 0.9996)) * 180.0 / Math.PI;
        latitude = Math.round(latitude * 1.0E7);
        double longitude = Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) * 180.0 / Math.PI + (double)(zone * 6) - 183.0;
        longitude = Math.round(longitude * 1.0E7);
        return new WGS84(latitude /= 1.0E7, longitude /= 1.0E7);
    }

    public String toWKT() {
        return "POINT( " + this.longitude + " " + this.latitude + " )";
    }
}

