/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.github.ansell.shp.UTM;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

public class UTMTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testGetEasting() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testGetNorthing() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testGetZone() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testGetLetter() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testToString() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testUTMIntCharDoubleDouble() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testUTMString() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="TODO: Implement me!")
    @Test
    public final void testFromWGS84WGS84() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="The TMcoords.dat uses false easting = 0 and false northing = 0, which aren't supported here yet.")
    @Test
    public final void testFromWGS84DoubleDouble() throws Exception {
        Path inputPath = Paths.get(new URI("file:/home/peter/Downloads/TMcoords.dat"));
        try (BufferedReader reader = Files.newBufferedReader(inputPath, StandardCharsets.UTF_8);){
            String line = null;
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                int northingCompare;
                ++lineCount;
                String[] split = line.split(" ");
                UTM nextUTM = UTM.fromWGS84((double)Double.parseDouble(split[0]), (double)Double.parseDouble(split[0]));
                int eastingCompare = Double.compare(Double.parseDouble(split[2]), nextUTM.getEasting());
                if (eastingCompare != 0) {
                    Assert.fail((String)("Found easting values that didn't match for line number: " + lineCount + " => " + line + " expected easting of: [" + split[2] + "] but found [" + nextUTM.getEasting() + "] utm=" + nextUTM.toString()));
                }
                if ((northingCompare = Double.compare(Double.parseDouble(split[3]), nextUTM.getNorthing())) == 0) continue;
                Assert.fail((String)("Found northing values that didn't match for line number: " + lineCount + " => " + line + " expected northing of: [" + split[3] + "] but found [" + nextUTM.getNorthing() + "] utm=" + nextUTM.toString()));
            }
        }
    }

    @Ignore
    @Test
    public final void testGeotoolsUTMMethod1() throws Exception {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:32632");
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
        Geometry sourceGeometry = null;
        Geometry targetGeometry = JTS.transform(sourceGeometry, (MathTransform)transform);
        System.out.println(targetGeometry);
    }

    @Ignore
    @Test
    public final void testGeotoolsUTMMethod2() throws Exception {
        double utmZoneCenterLongitude = -123.0;
        int zoneNumber = 10;
        double latitude = 0.0;
        double longitude = 0.0;
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ReferencingFactoryContainer factories = new ReferencingFactoryContainer(null);
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
        parameters.parameter("central_meridian").setValue(utmZoneCenterLongitude);
        parameters.parameter("latitude_of_origin").setValue(0.0);
        parameters.parameter("scale_factor").setValue(0.9996);
        parameters.parameter("false_easting").setValue(500000.0);
        parameters.parameter("false_northing").setValue(0.0);
        Map<String, String> properties = Collections.singletonMap("name", "WGS 84 / UTM Zone " + zoneNumber);
        CoordinateOperationFactory coordinateOperationFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);
        OperationMethod method = null;
        Conversion definingConversion = coordinateOperationFactory.createDefiningConversion(properties, method, parameters);
        ProjectedCRS projCRS = factories.createProjectedCRS(properties, (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)geoCRS, (CoordinateReferenceSystem)projCRS);
        double[] dest = new double[2];
        transform.transform(new double[]{longitude, latitude}, 0, dest, 0, 1);
        int easting = (int)Math.round(dest[0]);
        int northing = (int)Math.round(dest[1]);
    }
}

