/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.github.ansell.shp.WGS84;
import java.io.OutputStream;
import java.util.Arrays;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class UTM2WGS {
    public static void main(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec utmZoneOpt = parser.acceptsAll(Arrays.asList("z", "zone")).withRequiredArg().ofType(Integer.class).required().describedAs("The UTM Zone");
        ArgumentAcceptingOptionSpec utmLetterOpt = parser.acceptsAll(Arrays.asList("l", "letter")).withRequiredArg().ofType(String.class).required().describedAs("The UTM Letter");
        ArgumentAcceptingOptionSpec utmEastingOpt = parser.acceptsAll(Arrays.asList("e", "easting")).withRequiredArg().ofType(Double.class).required().describedAs("The UTM Easting");
        ArgumentAcceptingOptionSpec utmNorthingOpt = parser.acceptsAll(Arrays.asList("n", "northing")).withRequiredArg().ofType(Double.class).required().describedAs("The UTM Northing");
        ArgumentAcceptingOptionSpec printWkt = parser.accepts("output-wkt").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]).describedAs("Output WKT version");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        WGS84 fromUTM = WGS84.fromUTM((Integer)utmZoneOpt.value(options), ((String)utmLetterOpt.value(options)).charAt(0), (Double)utmEastingOpt.value(options), (Double)utmNorthingOpt.value(options));
        if (options.has((OptionSpec)printWkt) && ((Boolean)printWkt.value(options)).booleanValue()) {
            System.out.println(fromUTM.toWKT());
        } else {
            System.out.println(fromUTM.toString());
        }
    }
}

