/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import cormoran.pepper.avro.IBinaryToAvroStream;
import cormoran.pepper.io.PepperFileHelper;
import cormoran.pepper.parquet.ParquetStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;

public class ParquetBytesToStream
implements IBinaryToAvroStream {
    protected final AtomicReference<Path> persisted = new AtomicReference();

    protected void persist(InputStream inputStream) throws IOException {
        if (this.persisted.get() != null) {
            throw new RuntimeException("Already persisted on " + this.persisted.get());
        }
        boolean deleteOnExit = true;
        Path tmp = PepperFileHelper.createTempPath((String)this.getClass().getSimpleName(), (String)".tmp", (boolean)deleteOnExit);
        Files.copy(inputStream, tmp, StandardCopyOption.REPLACE_EXISTING);
        this.persisted.set(tmp);
    }

    public Stream<GenericRecord> stream(InputStream inputStream) throws IOException {
        this.persist(inputStream);
        return new ParquetStreamFactory().toStream(this.persisted.get());
    }

    public Stream<GenericRecord> stream(Path path) throws IOException {
        return new ParquetStreamFactory().toStream(path);
    }
}

