/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import com.google.common.base.Suppliers;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import cormoran.pepper.avro.AvroStreamHelper;
import cormoran.pepper.avro.IAvroStreamFactory;
import cormoran.pepper.parquet.ParquetBytesToStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.filter.PagedRecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;

public class ParquetStreamFactory
implements IAvroStreamFactory {
    private static final Supplier<Configuration> DEFAULT_CONFIGURATION = Suppliers.memoize(() -> new Configuration());
    private final Configuration configuration;

    public static Configuration cloneDefaultConfiguration() {
        DEFAULT_CONFIGURATION.get().get("name");
        return new Configuration(DEFAULT_CONFIGURATION.get());
    }

    public ParquetStreamFactory() {
        this(ParquetStreamFactory.cloneDefaultConfiguration());
    }

    public ParquetStreamFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Stream<GenericRecord> toStream(java.nio.file.Path javaPath) throws IOException {
        Path hadoopPath = this.toHadoopPath(javaPath);
        return this.toStream(hadoopPath);
    }

    public Stream<GenericRecord> toStream(Path hadoopPath) throws IOException {
        FilterCompat.Filter filter = this.makeFilter();
        ParquetReader reader = AvroParquetReader.builder((Path)hadoopPath).withFilter(filter).withConf(this.getConfiguration()).build();
        return this.toStream((ParquetReader<GenericRecord>)reader);
    }

    public Stream<? extends Map<String, ?>> toStream(java.nio.file.Path path, Map<String, ?> exampleTypes) throws IOException {
        return this.toStream(path).map(AvroStreamHelper.toJavaMap(exampleTypes));
    }

    protected FilterCompat.Filter makeFilter() {
        return FilterCompat.get((UnboundRecordFilter)PagedRecordFilter.page((long)0L, (long)Long.MAX_VALUE));
    }

    protected Stream<GenericRecord> toStream(final ParquetReader<GenericRecord> reader) {
        return Streams.stream((Iterator)new AbstractIterator<GenericRecord>(){

            protected GenericRecord computeNext() {
                GenericRecord next;
                try {
                    next = (GenericRecord)reader.read();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (next == null) {
                    return (GenericRecord)this.endOfData();
                }
                return next;
            }
        });
    }

    public static Stream<Map<String, ?>> readParquetAsStream(java.nio.file.Path pathOnDisk, Map<String, ?> exampleTypes) throws FileNotFoundException, IOException {
        return new ParquetBytesToStream().stream(new FileInputStream(pathOnDisk.toFile())).map(AvroStreamHelper.toJavaMap(exampleTypes));
    }

    public long writeToPath(java.nio.file.Path javaPathOnDisk, Stream<? extends GenericRecord> rowsToWrite) throws IOException {
        if (javaPathOnDisk.toFile().exists()) {
            throw new IllegalArgumentException("Can not write to an existing file:" + javaPathOnDisk);
        }
        AtomicReference writer = new AtomicReference();
        AtomicLong nbRows = new AtomicLong();
        rowsToWrite.forEach(m -> {
            if (nbRows.get() == 0L) {
                try {
                    writer.set(AvroParquetWriter.builder((Path)this.toHadoopPath(javaPathOnDisk)).withSchema(m.getSchema()).build());
                }
                catch (NullPointerException e) {
                    throw new IllegalStateException("Are you missing Hadoop binaries?", e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                ((ParquetWriter)writer.get()).write(m);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            nbRows.incrementAndGet();
        });
        if (writer.get() != null) {
            ((ParquetWriter)writer.get()).close();
        }
        return nbRows.get();
    }

    protected Path toHadoopPath(java.nio.file.Path javaPathOnDisk) {
        return new Path(javaPathOnDisk.toUri());
    }
}

