/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import com.google.common.base.Suppliers;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import cormoran.pepper.avro.AvroStreamFactory;
import cormoran.pepper.avro.AvroTranscodingHelper;
import cormoran.pepper.avro.IGenericRecordConsumer;
import cormoran.pepper.parquet.ParquetBytesToStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.filter.PagedRecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;

public class ParquetStreamFactory
extends AvroStreamFactory {
    private static final Supplier<Configuration> DEFAULT_CONFIGURATION = Suppliers.memoize(() -> new Configuration());
    private final Configuration configuration;

    public static Configuration cloneDefaultConfiguration() {
        DEFAULT_CONFIGURATION.get().get("name");
        return new Configuration(DEFAULT_CONFIGURATION.get());
    }

    public ParquetStreamFactory() {
        this(ParquetStreamFactory.cloneDefaultConfiguration());
    }

    public ParquetStreamFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Stream<GenericRecord> stream(URI uri) throws IOException {
        Path hadoopPath = this.toHadoopPath(uri);
        return this.toStream(hadoopPath);
    }

    public Stream<GenericRecord> stream(InputStream rawInputStream) throws IOException {
        return (Stream)new ParquetBytesToStream().stream(rawInputStream).onClose(() -> {
            try {
                rawInputStream.close();
            }
            catch (IOException e) {
                LOGGER.trace("Ouch on closing", (Throwable)e);
            }
        });
    }

    public Stream<GenericRecord> toStream(Path hadoopPath) throws IOException {
        ParquetReader reader;
        FilterCompat.Filter filter = this.makeFilter();
        try {
            reader = AvroParquetReader.builder((Path)hadoopPath).withFilter(filter).withConf(this.getConfiguration()).build();
        }
        catch (IOException e) {
            throw new IOException("Issue on path: " + hadoopPath, e);
        }
        catch (RuntimeException e) {
            throw new IOException("Issue on path: " + hadoopPath, e);
        }
        return this.toStream((ParquetReader<GenericRecord>)reader);
    }

    protected FilterCompat.Filter makeFilter() {
        return FilterCompat.get((UnboundRecordFilter)PagedRecordFilter.page((long)0L, (long)Long.MAX_VALUE));
    }

    protected Stream<GenericRecord> toStream(final ParquetReader<GenericRecord> reader) {
        return Streams.stream((Iterator)new AbstractIterator<GenericRecord>(){

            protected GenericRecord computeNext() {
                GenericRecord next;
                try {
                    next = (GenericRecord)reader.read();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (next == null) {
                    return (GenericRecord)this.endOfData();
                }
                return next;
            }
        });
    }

    public static Stream<Map<String, ?>> readParquetAsStream(URI uriToParquet, Map<String, ?> exampleTypes) throws FileNotFoundException, IOException {
        File file = Paths.get(uriToParquet).toFile();
        return new ParquetBytesToStream().stream(new FileInputStream(file)).map(AvroTranscodingHelper.toJavaMap(exampleTypes));
    }

    protected IGenericRecordConsumer prepareRecordConsumer(Schema schema, URI uri) throws IOException {
        final ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)this.toHadoopPath(uri)).withSchema(schema).withConf(this.getConfiguration())).build();
        return new IGenericRecordConsumer(){

            public void accept(GenericRecord t) {
                try {
                    writer.write((Object)t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void close() throws IOException {
                writer.close();
            }
        };
    }

    protected Path toHadoopPath(URI uri) {
        return new Path(uri);
    }
}

